/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef OPTIONEDITORHEADERFILE
#define OPTIONEDITORHEADERFILE

#include <QWidget>
#include <QLineEdit>

#include <QItemDelegate>
#include <QTreeWidget>
#include <QStringList>

class QToolButton;
class QResizeEvent;
class QDateTime;
class TOptionItemDelegate;

class TPathEdit : public QLineEdit
{
Q_OBJECT
public:

// CREATORS
	TPathEdit(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TPathEdit(void);

// ACCESSORS

// MANIPULATORS
	void Set_Row(const int i) {d_row = i;}
	void Set_Column(const int i) {d_column = i;}

protected:
	virtual void resizeEvent(QResizeEvent *even);
	
private:
	QToolButton 						*d_BrowseButton;
	QDateTime							*d_DateTime;
	int									d_row;
	int									d_column;

// NOT IMPLEMENTED
	TPathEdit(const TPathEdit&);
	TPathEdit& operator=(const TPathEdit&);
	
signals:
	void Browse_Path(const QString,int,int);		// default_path,row, column
	
private slots:
	void Browse_Path_Clicked(void);
	
};

class TOptionEditorWidget : public QTreeWidget
{
	Q_OBJECT
	
public:
// CREATORS
	TOptionEditorWidget(const QWidget *parent=0);
	virtual ~TOptionEditorWidget(void);
	
// ACCESSORS
	QString Option_Name(const int index) const;						// Get the option title
	QString Option_Value(const int index) const;					// Get the option value

// MANIPULATORS
	
	// all options return a zero based index of the item.
	int Add_Line_Editor_Option(const QString &Title,
			const QString &DefaultValue,
			const QString &Column2 = QString(),
			const QString &Column3 = QString(),
			const QString &Column4 = QString(),
			const QString &Column5 = QString(),
			const QString &Column6 = QString());
	int Add_Line_Editor_Option(const QString &Title,
			const int DefaultValue,
			const QString &Column2 = QString(),
			const QString &Column3 = QString(),
			const QString &Column4 = QString(),
			const QString &Column5 = QString(),
			const QString &Column6 = QString());
	int Add_Path_Editor_Option(const QString &Title,const QString &DefaultPath);
	int Add_Checkbox_Option(const QString &Title,
			const bool State,
			const QString &Column2 = QString(),
			const QString &Column3 = QString(),
			const QString &Column4 = QString(),
			const QString &Column5 = QString(),
			const QString &Column6 = QString());
	int Add_DateTime_Option(const QString &Title,const QDateTime &DefaultDateTime);
	int Add_Combobox_Option(const QString &Title,
			const QStringList &Items,
			const int DefaultIndex = 0,
			const QString &Column2 = QString(),
			const QString &Column3 = QString(),
			const QString &Column4 = QString(),
			const QString &Column5 = QString(),
			const QString &Column6 = QString());
	
	void Change_Combobox_Option(const int ItemIndex,const int ListIndex);
	
	bool Change_Option_Text(const int index,const QString &text);			// Set the current option value
	bool Change_Option_Text(const int index,const int value);				// Set the current option value
	void Enable_Option(const int index,const bool state);

signals:
	void Option_Combo_Item_Changed(int,const QString&);					// index, new text
	
public slots:
	void Path_Edit_Browse(const QString,const int row,const int column);	// default path, row, column
	
private slots:
	void Edit_List_Changed(int,const QString&);							// index, text

private:
	TOptionItemDelegate					*d_item_delegate;


// NOT IMPLEMENTED
	TOptionEditorWidget(const TOptionEditorWidget&);
	TOptionEditorWidget& operator=(const TOptionEditorWidget&);
};


class TOptionItemDelegate : public QItemDelegate
{
	
Q_OBJECT

public:
    TOptionItemDelegate(const QObject *parent = 0);
    virtual ~TOptionItemDelegate(void);
    
    virtual QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &style_option_view_item,const QModelIndex &index) const;
    virtual void setEditorData(QWidget *editor, const QModelIndex &index) const;
    virtual void setModelData(QWidget *editor, QAbstractItemModel *model,const QModelIndex &index) const;
	
	void Set_Child_Dialog_Parent(TOptionEditorWidget *ow) {d_option_editor_widget = ow;}
	
protected:
	virtual QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex & index) const;

signals:
	void List_Item_Changed(int,const QString&);
    
private slots:
    void commitAndCloseEditor();
    void Combo_Item_Changed(const int);
    
    
private:
	TOptionEditorWidget					*d_option_editor_widget;
	
	mutable int							d_active_row;
	mutable int							d_active_column;
};


#endif
