CONFIG +=			release \
					warn_on \
					qt \
					thread \
					c++11

# DEFINES	+=			INCLUDE_SRC_EXTRA
# DEFINES	+=			ENABLE_DEBUG_MODE

contains(DEFINES, ENABLE_DEBUG_MODE) {
win32 {
	CONFIG +=		console
}
}

TEMPLATE =			app
DESTDIR =			../bin

linux-g++{
	DESTDIR =		bin
}

CONFIG(debug, debug|release) {
	TARGET =		measuredirectd
} else {
	TARGET =		measuredirect
}

OBJECTS_DIR =		build/obj
MOC_DIR =			build/moc

QT +=				core \
					gui \
					xml \
					network

greaterThan(QT_MAJOR_VERSION, 4): {
QT +=				widgets

}

# DEPENDPATH +=		<relative path>/lib
# INCLUDEPATH +=	<relative path>/src
# LIBS+=			-L<relative path>/lib -l<library name>

DEPENDPATH += 		../../libserialdevice/lib
INCLUDEPATH += 		../../libserialdevice/src
LIBS+=  			-L../../libserialdevice/lib -lserialdevice

SOURCES +=			../../core/bestfitcircle.cpp \
					../../core/bestfitline.cpp \
					../../core/bestfitplane.cpp \
					../../core/bestfitsphere.cpp \
					../../core/gaugewidget.cpp \
					../../core/graphwidget.cpp \
					../../core/mat4.cpp \
					../../core/matrix.cpp \
					../../core/messagebox.cpp \
					../../core/optioneditor.cpp \
					../../core/referencesystem.cpp \
					../../core/vector2.cpp \
					../../core/vector3.cpp \
					../../core/xmlfile.cpp \
					src/cmmwidget.cpp \
					src/command.cpp \
					src/command_align.cpp \
					src/command_dimension.cpp \
					src/command_feature.cpp \
					src/command_feature_circle.cpp \
					src/command_feature_line.cpp \
					src/command_feature_plane.cpp \
					src/command_feature_point.cpp \
					src/command_feature_sphere.cpp \
					src/command_modal.cpp \
					src/command_modal_mode.cpp \
					src/command_modal_prompt.cpp \
					src/command_modal_sync.cpp \
					src/command_move.cpp \
					src/command_move_cube.cpp \
					src/command_querytool.cpp \
					src/command_sequence.cpp \
					src/command_settool.cpp \
					src/controller.cpp \
					src/controller_dc.cpp \
					src/controller_ippclient.cpp \
					src/controller_leitz.cpp \
					src/coordinatedisplaywidget.cpp \
					src/coordinatewidget.cpp \
					src/driver.cpp \
					src/executionqueuewidget.cpp \
					src/exercisedialog.cpp \
					src/iconwidget.cpp \
					src/informationwidget.cpp \
					src/inputwidget.cpp \
					src/inputwidgetitem.cpp \
					src/laserdialog.cpp \
					src/laserinputedit.cpp \
					src/laseroffsetdialog.cpp \
					src/linkdialog.cpp \
					src/linkprotocol.cpp \
					src/logdialog.cpp \
					src/logowidget.cpp \
					src/main.cpp \
					src/measure_outputdialog.cpp \
					src/measure_routines.cpp \
					src/measuredialog.cpp \
					src/measuredirect.cpp \
					src/measurewidget.cpp \
					src/nameeditdialog.cpp \
					src/pathpoint.cpp \
					src/pointcountwidget.cpp \
					src/reportwidget.cpp \
					src/settings_artifactdialog.cpp \
					src/settings_machinedialog.cpp \
					src/settingswidget.cpp \
					src/tempcompinformationdialog.cpp \
					src/temperaturemonitordialog.cpp \
					src/titlewidget.cpp \
					src/tooladdanglesdialog.cpp \
					src/toolbuilderdata.cpp \
					src/toolbuilderdialog.cpp \
					src/tooldata.cpp \
					src/toolutilitiesdialog.cpp \
					src/toolwidget.cpp \
					src/validationdialog.cpp

HEADERS +=			../../core/bestfitcircle.h \
					../../core/bestfitline.h \
					../../core/bestfitplane.h \
					../../core/bestfitsphere.h \
					../../core/gaugewidget.h \
					../../core/graphwidget.h \
					../../core/mat4.h \
					../../core/matrix.h \
					../../core/messagebox.h \
					../../core/optioneditor.h \
					../../core/referencesystem.h \
					../../core/vector2.h \
					../../core/vector3.h \
					../../core/xmlfile.h \
					src/cmmwidget.h \
					src/command.h \
					src/command_align.h \
					src/command_dimension.h \
					src/command_feature.h \
					src/command_feature_circle.h \
					src/command_feature_line.h \
					src/command_feature_plane.h \
					src/command_feature_point.h \
					src/command_feature_sphere.h \
					src/command_modal.h \
					src/command_modal_mode.h \
					src/command_modal_prompt.h \
					src/command_modal_sync.h \
					src/command_move.h \
					src/command_move_cube.h \
					src/command_querytool.h \
					src/command_sequence.h \
					src/command_settool.h \
					src/controller.h \
					src/controller_dc.h \
					src/controller_ippclient.h \
					src/controller_leitz.h \
					src/coordinatedisplaywidget.h \
					src/coordinatewidget.h \
					src/driver.h \
					src/executionqueuewidget.h \
					src/exercisedialog.h \
					src/iconwidget.h \
					src/informationwidget.h \
					src/inputwidget.h \
					src/inputwidgetitem.h \
					src/laserdialog.h \
					src/laserinputedit.h \
					src/laseroffsetdialog.h \
					src/linkdialog.h \
					src/linkprotocol.h \
					src/logdialog.h \
					src/logowidget.h \
					src/measure_outputdialog.h \
					src/measure_routines.h \
					src/measure_types.h \
					src/measuredialog.h \
					src/measuredirect.h \
					src/measurewidget.h \
					src/nameeditdialog.h \
					src/pathpoint.h \
					src/pointcountwidget.h \
					src/reportwidget.h \
					src/settings_artifactdialog.h \
					src/settings_machinedialog.h \
					src/settingswidget.h \
					src/tempcompinformationdialog.h \
					src/temperaturemonitordialog.h \
					src/titlewidget.h \
					src/tooladdanglesdialog.h \
					src/toolbuilderdata.h \
					src/toolbuilderdialog.h \
					src/tooldata.h \
					src/toolutilitiesdialog.h \
					src/toolwidget.h \
					src/validationdialog.h

contains(DEFINES, INCLUDE_SRC_EXTRA) {
	SOURCES +=		src_extra/controller_dc_code.cpp
	HEADERS +=		src_extra/controller_dc_code.h
}

RESOURCES +=		res/measuredirect.qrc

macx{

ICON =			res/icons.icns
QMAKE_INFO_PLIST = ../../default_data/Info.plist
}

linux-g++{

isEmpty(PREFIX) {
PREFIX = 			/usr/lib/measuredirect
}
target.path =		$$PREFIX
target.files =		bin/measuredirect
INSTALLS +=			target
}

win32 {
RC_FILE =			res/resource.rc
}
