/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDHEADERFILE
#define COMMANDHEADERFILE

class TCommand
{
public:
	
enum TCommandType
{
	COMMAND_NULL = 0,
	COMMAND_ALIGN,
	COMMAND_MEASURE_PLANE,
	COMMAND_MEASURE_LINE,
	COMMAND_MEASURE_POINT,
	COMMAND_MEASURE_SPHERE,
	COMMAND_MEASURE_CIRCLE,
	COMMAND_MODAL_MODE,
	COMMAND_MODAL_PROMPT,
	COMMAND_MODAL_SYNC,
	COMMAND_MOVE,
	COMMAND_MOVE_CUBE,
	COMMAND_DIMENSION,
	COMMAND_QUERY_TOOL,
	COMMAND_SET_TOOL
};
	
// CREATORS
	TCommand(void);
	virtual ~TCommand(void) = 0;
	
// ACCESSORS
	TCommandType Type(void) const {return d_command_type;}
	
// MANIPULATORS
	
protected:
	TCommandType						d_command_type;
	
	
private:
	
// NOT IMPLEMENTED
	TCommand(const TCommand&);
	TCommand& operator=(const TCommand&);
};

#endif
