/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDDIMENSIONHEADERFILE
#define COMMANDDIMENSIONHEADERFILE

#include <QString>
#include <vector>

#include "command.h"

class TCommandDimension : public TCommand
{
public:
	
enum TDimensionFormat
{
	FORMAT_MEAS = 0,
	FORMAT_ERR,
	FORMAT_COMPLETE
};
	
enum TDimensionField
{
	FIELD_X=0,
	FIELD_Y,
	FIELD_Z,
	FIELD_DIST_X,
	FIELD_DIST_Y,
	FIELD_DIST_Z,
	FIELD_DIST_XYZ,
	FIELD_FORM,
	FIELD_DIAM
};
	
struct TDimensionItem
{
	TDimensionFormat					dimension_format;
	TDimensionField						dimension_field;
	QString								axis_name;
	double								nominal;
	double								actual;
	double								utol;
	double								ltol;
};
	
	// CREATORS
	TCommandDimension(void);
	virtual ~TCommandDimension(void);
	
	// ACCESSORS
	int Dimension_Item_Count(void) const {return static_cast<int>(d_dimensions.size());}
	TDimensionItem Dimension_Item(const int index);
	QString Dimension_Item_Text(const int index);	// output a formatted line of text
	
	int Memory_Id_Feature1(void) const {return d_memory_id_feature1;}
	int Memory_Id_Feature2(void) const {return d_memory_id_feature2;}
	QString Dimension_Name(void) const {return d_dimension_name;}
	
	static QString Dimension_Item_Text_Title_Meas(void);
	static QString Dimension_Item_Text_Title_Err(void);
	static QString Dimension_Item_Text_Title_Complete(void);

	// MANIPULATORS
	void Set_Memory_Id_Feature1(const int &memory_id){d_memory_id_feature1 = memory_id;}
	void Set_Memory_Id_Feature2(const int &memory_id){d_memory_id_feature2 = memory_id;}
	void Set_Dimension_Name(const QString &s) {d_dimension_name = s;}
	
	void Set_Actual(const TDimensionField field,const double &value);
	void Set_Nominal(const TDimensionField field,const double &value);
	
	void Add_Dimension(const TDimensionItem &item);
	
	void Add_Dimension(const TDimensionField field,const QString &axis_name,const double &actual);
	void Add_Dimension(const TDimensionField field,const QString &axis_name,const double &actual,const double &nominal);
	void Add_Dimension(const TDimensionField field,const QString &axis_name,const double &actual,const double &nominal, const double &utol,const double &ltol);
	
private:
	int									d_memory_id_feature1;
	int									d_memory_id_feature2;
	QString								d_dimension_name;
	std::vector<TDimensionItem>			d_dimensions;
	
	// NOT IMPLEMENTED
	TCommandDimension(const TCommandDimension&);
	TCommandDimension& operator=(const TCommandDimension&);
};

#endif
