/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <assert.h>

#include "command_move_cube.h"

TCommandMoveCube::TCommandMoveCube(void)
{
	d_command_type = TCommand::COMMAND_MOVE_CUBE;
	d_axis = TCommandMoveCube::ZPLUS;
}

TCommandMoveCube::~TCommandMoveCube(void)
{
}

TVector3 TCommandMoveCube::Get_Next_Point(
	bool								* const valid)
{
	TVector3							pnt;
	
	assert(valid);
	
	*valid = false;
	
	if(d_move_points.size())
	{
		*valid = true;
		
		pnt = d_move_points[0];
		d_move_points.erase(d_move_points.begin());
	}
	
	return pnt;
}
void TCommandMoveCube::Set_Axis(
	const TCommandMoveCube::TAxis		axis,
	const double						&position)
{
	d_axis = axis;
	d_position = position;
}

void TCommandMoveCube::Add_Point(
	const TVector3						&pnt)
{
	d_move_points.push_back(pnt);
}

