/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDSETTOOLHEADERFILE
#define COMMANDSETTOOLHEADERFILE

#include <QString>

#include "../../../core/vector3.h"

#include "command.h"

class TCommandSetTool : public TCommand
{
public:
	
	// CREATORS
	TCommandSetTool(void);
	virtual ~TCommandSetTool(void);
	
	// ACCESSORS
	QString Name(void) const {return d_tool_name;}
	TVector3 Offset(void) const {return d_offset;}
	TVector3 Vector(void) const {return d_vector;}
	double Angle_A(void) const {return d_angle_a;}
	double Angle_B(void) const {return d_angle_b;}
	double Tip_Diameter(void) const {return d_tip_diameter;}
	
	// MANIPULATORS
	void Set_Name(const QString &name) {d_tool_name = name;}
	void Set_Offset(const TVector3 &offset) {d_offset = offset;}
	void Set_Vector(const TVector3 &vector) {d_vector = vector;}
	void Set_Angle_A(const double &d) {d_angle_a = d;}
	void Set_Angle_B(const double &d) {d_angle_b = d;}
	void Set_Tip_Diameter (const double &td) {d_tip_diameter = td;}
	
private:
	
	QString								d_tool_name;
	double								d_angle_a;
	double								d_angle_b;
	double								d_tip_diameter;
	TVector3							d_offset;
	TVector3							d_vector;
	
	// NOT IMPLEMENTED
	TCommandSetTool(const TCommandSetTool&);
	TCommandSetTool& operator=(const TCommandSetTool&);
};

#endif
