/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef CONTROLLERDCHEADERFILE
#define CONTROLLERDCHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "linkprotocol.h"
#include "controller.h"

class TControllerDC : public TController
{
public:
	
	// CREATORS
	TControllerDC(const TLinkProtocol::TProtocolType protocol_type);
	virtual ~TControllerDC(void);
	
	// ACCESSORS

	// MANIPULATORS
	virtual bool Connect(void);
	virtual bool Initialize(void);
	virtual bool Refresh_Tools(void);
	virtual bool Send_Home(void);
	virtual void Disconnect(void);
	virtual void Close(void);
	
	virtual bool Clear_Error(void);
	virtual void Check_Machine_Status(void);
	virtual void Abort(void);
	
	virtual bool Set_Tool_Type(const QString &tool_type);
	virtual bool Set_Tool_Data(const TVector3 &xyz,const double &tip_diameter);
	virtual bool Set_Tool_Angles(const double &angle_a,const double &angle_b);
	
	virtual bool Set_Move_Speed(const double&);
	virtual bool Set_Touch_Speed(const double&);
	virtual bool Set_Acceleration(const double&);
	virtual bool Set_Approach_Distance(const double&);
	virtual bool Enable_Blended_Moves(void);
	virtual bool Disable_Blended_Moves(void);

	virtual bool Get_Position(TVector3 * const pnt);
	virtual bool Get_Position_DRO(TVector3 * const pnt);
	virtual bool Move_To(const TVector3 &pnt);
	virtual bool Touch(const TVector3 &target, const TVector3 &approach);
	
	virtual bool Get_X_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Y_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Z_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Part_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Sensor_Value(int sensor_id);

	virtual bool Set_Part_Expansion_Coefficient(const double &expansion_coefficient);
	
	virtual QString Get_X_Sensors(void);
	virtual QString Get_Y_Sensors(void);
	virtual QString Get_Z_Sensors(void);
	virtual QString Get_Part_Sensors(void);

	virtual void Process_Rx_Data(void);
	
private:
	
	TVector3							d_current_position;
	QByteArray							d_rx_data;
	double								d_current_touch_speed;
	std::vector<int>					d_sensor_ids;
	
	void Process_Touch_Point(const QString &text);
	void Process_Pos(const QString &text);
	void Process_Sensor(const QString &text);
	
	bool Get_Sensor_Data(const QString &sensor_list,double * const value,bool * const valid);
	
	bool Initialize_Software_Authentication(void);
	bool Complete_Software_Authentication(const QString &srcnum);

	// NOT IMPLEMENTED
	TControllerDC(const TControllerDC&);
	TControllerDC& operator=(const TControllerDC&);
};

#endif
