/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef CONTROLLERIPPCLIENTHEADERFILE
#define CONTROLLERIPPCLIENTHEADERFILE

#include "linkprotocol.h"
#include "controller.h"

class TControllerIppClient : public TController
{
public:
	
	// CREATORS
	TControllerIppClient(const TLinkProtocol::TProtocolType protocol_type);
	virtual ~TControllerIppClient(void);
	
	// ACCESSORS
	virtual QStringList Get_Ipp_Tool_List(void);

	// MANIPULATORS
	virtual bool Connect(void);
	virtual bool Initialize(void);
	virtual bool Refresh_Tools(void);
	virtual bool Send_Home(void);
	virtual void Disconnect(void);
	virtual void Close(void);
	
	virtual bool Clear_Error(void);
	virtual void Check_Machine_Status(void);
	virtual void Abort(void);
	
	virtual bool Query_Tool(const QString &tool_name);
	virtual bool Set_Tool_Name(const QString &tool_name);
	virtual bool Set_Tool_Data(const TVector3 &xyz,const double &tip_diameter);		// tip_diameter not changed for I++
	virtual void Set_Mode(const TMode mode);
	
	virtual bool Set_Move_Speed(const double&);
	virtual bool Set_Touch_Speed(const double&);
	virtual bool Set_Acceleration(const double&);
	virtual bool Set_Approach_Distance(const double&);
	virtual bool Enable_Position_Updates(const bool state,const bool precision_update);

	virtual bool Get_Position(TVector3 * const pnt);
	virtual bool Get_Position_DRO(TVector3 * const pnt);
	virtual bool Move_To(const TVector3 &pnt);
	virtual bool Touch(const TVector3 &target, const TVector3 &approach);
	
	virtual bool Get_X_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Y_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Z_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Part_Temperature(const QString &sensor_list,double * const value,bool * const valid);
	virtual bool Get_Sensor_Value(int sensor_id);			// 1=x, 2=y, 3=z, 4=part
	
	virtual bool Set_Part_Expansion_Coefficient(const double &expansion_coefficient);
	
	virtual QString Get_X_Sensors(void);
	virtual QString Get_Y_Sensors(void);
	virtual QString Get_Z_Sensors(void);
	virtual QString Get_Part_Sensors(void);

	virtual void Process_Rx_Data(void);

private:
	
	int									d_command_id;
	int									d_event_command_id;
	QStringList							d_ipp_tool_list;
	QByteArray							d_rx_data;
	TVector3							d_current_position;
	std::vector<QString>				d_touch_ids;
	QString								d_coordinate_id;

	bool Is_Touch(const QString &text);		// removes touch_id if found
	
	void Process_Manual_Touch(const QString &text);
	void Process_Touch(const QString &text);
	void Process_Coordinate_Update(const QString &text);
	void Process_Machine_Temeprature_X(const QString &text);
	void Process_Machine_Temeprature_Y(const QString &text);
	void Process_Machine_Temeprature_Z(const QString &text);
	void Process_Part_Temeprature(const QString &text);


	// NOT IMPLEMENTED
	TControllerIppClient(const TControllerIppClient&);
	TControllerIppClient& operator=(const TControllerIppClient&);
};


#endif
