/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFont>
#include <QGridLayout>
#include <QLabel>
#include <QSizePolicy>
#include <QFontMetrics>

#include "coordinatewidget.h"
#include "coordinatedisplaywidget.h"

TCoordinateDisplayWidget::TCoordinateDisplayWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QFont								font;
	QGridLayout							*widget_layout;
	QLabel								*x_label;
	QLabel								*y_label;
	QLabel								*z_label;
	QSizePolicy							size_policy_maximum_preferred(QSizePolicy::Maximum,QSizePolicy::Preferred);
	int									display_width;

	size_policy_maximum_preferred.setHorizontalStretch(0);
	size_policy_maximum_preferred.setVerticalStretch(0);

	font.setPointSize(24);
	
	QFontMetrics font_metrics(font);
	display_width = font_metrics.averageCharWidth() * 12;

	widget_layout = new QGridLayout(this);

	x_label = new QLabel(this);
	x_label->setSizePolicy(size_policy_maximum_preferred);
	x_label->setFont(font);
	x_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(x_label,0,0,1,1);

	d_x_value_label = new TCoordinateWidget(this);
	d_x_value_label->setFont(font);
	d_x_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_x_value_label->setFixedWidth(display_width);
	d_x_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_x_value_label,0,1,1,1);

	y_label = new QLabel(this);
	y_label->setSizePolicy(size_policy_maximum_preferred);
	y_label->setFont(font);
	y_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(y_label,1,0,1,1);

	d_y_value_label = new TCoordinateWidget(this);
	d_y_value_label->setFont(font);
	d_y_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_y_value_label->setFixedWidth(display_width);
	d_y_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_y_value_label,1,1,1,1);

	z_label = new QLabel(this);
	z_label->setSizePolicy(size_policy_maximum_preferred);
	z_label->setFont(font);
	z_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	widget_layout->addWidget(z_label,2,0,1,1);

	d_z_value_label = new TCoordinateWidget(this);
	d_z_value_label->setFont(font);
	d_z_value_label->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
	d_z_value_label->setFixedWidth(display_width);
	d_z_value_label->setFixedWidth(display_width);
	widget_layout->addWidget(d_z_value_label,2,1,1,1);
	
	d_x_value_label->Set_Precision(4);
	d_y_value_label->Set_Precision(4);
	d_z_value_label->Set_Precision(4);

	x_label->setText(QStringLiteral("X:"));
	y_label->setText(QStringLiteral("Y:"));
	z_label->setText(QStringLiteral("Z:"));
}

TCoordinateDisplayWidget::~TCoordinateDisplayWidget(void)
{
}

TVector3 TCoordinateDisplayWidget::Get_XYZ(void) const
{
	TVector3							position;
	
	position.x = d_x_value_label->Value();
	position.y = d_y_value_label->Value();
	position.z = d_z_value_label->Value();
	
	return position;
}

void TCoordinateDisplayWidget::Set_X(
	const double						&value)
{
	d_x_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Y(
	const double						&value)
{
	d_y_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_Z(
	const double						&value)
{
	d_z_value_label->Set_Value(value);
}

void TCoordinateDisplayWidget::Set_XYZ(
	const TVector3						&xyz)
{
	d_x_value_label->Set_Value(xyz.x);
	d_y_value_label->Set_Value(xyz.y);
	d_z_value_label->Set_Value(xyz.z);
}
