/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QPainter>
#include <QFont>
#include <QFontMetrics>
#include <QRect>
#include <QPaintEvent>
#include <QChar>
#include <QFont>
#include <QFontMetrics>

#include "coordinatewidget.h"

TCoordinateWidget::TCoordinateWidget(
	const QWidget						*parent,
	Qt::WindowFlags						flags)
:QLabel(const_cast<QWidget*>(parent),flags)
{
	d_value = 0.0;
	d_precision = 3;
}

TCoordinateWidget::~TCoordinateWidget(void)
{
}

QSize TCoordinateWidget::sizeHint(void) const
{
	QRect								rect;
	QFontMetrics						font_metrics(this->font());
	
	rect = font_metrics.boundingRect(QString("%1").arg(d_value,0,'f',d_precision));
	
	return rect.size();
}

void TCoordinateWidget::paintEvent(
	QPaintEvent							*event)
{
	Q_UNUSED(event);
	
	QPainter							painter(this);
	QString								text;
	QChar								text_char;
	QRect								rect(this->rect());
	QRect								cell_rect;
	int									cntr;
	int									char_width;
	QFontMetrics						font_metrics(this->font());
	
	text = QString("%1").arg(d_value,0,'f',d_precision);
	
	char_width = font_metrics.boundingRect('0').width() + 2;
	
	cell_rect = rect;
	cell_rect.setLeft(cell_rect.right() - char_width);
	
	// assume right aligned text
	cntr = text.length();
	
	if(cntr)
	{
		do
		{
			--cntr;
			
			text_char = text.at(cntr);
			painter.drawText(cell_rect,Qt::AlignHCenter | Qt::AlignVCenter,QString(text_char));
			
			cell_rect.adjust(-char_width,0,-char_width,0);
			
		} while(cntr);
	}
}
