/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef COORDINATEWIDGETHEADERFILE
#define COORDINATEWIDGETHEADERFILE

#include <QLabel>
#include <QSize>

class QPaintEvent;

class TCoordinateWidget : public QLabel
{
Q_OBJECT
public:
// CREATORS
	TCoordinateWidget(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TCoordinateWidget(void);
	
// ACCESSORS
	double Value(void) const {return d_value;}
	
	virtual QSize sizeHint(void) const;
	
// MANIPULATORS
	void Set_Precision(const int i) {d_precision = i;}
	void Set_Value(const double &d) {d_value = d; this->update();}
	
protected:
	virtual void paintEvent(QPaintEvent *event);

private:
	double								d_value;
	int									d_precision;
	
// NOT IMPLEMENTED
	TCoordinateWidget(const TCoordinateWidget&);
	TCoordinateWidget& operator=(const TCoordinateWidget&);
};


#endif
