/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFont>
#include <QHBoxLayout>
#include <QPlainTextEdit>

#include "executionqueuewidget.h"

TExecutionQueueWidget::TExecutionQueueWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QFont								font;
	QHBoxLayout							*horizontalLayout;

	font.setFamily(QStringLiteral("Courier New"));

	this->resize(1024,350);

	horizontalLayout = new QHBoxLayout(this);

	d_queue_edit = new QPlainTextEdit(this);
	d_queue_edit->setFont(font);
	d_queue_edit->setUndoRedoEnabled(false);
	d_queue_edit->setLineWrapMode(QPlainTextEdit::NoWrap);
	horizontalLayout->addWidget(d_queue_edit);

	d_response_edit = new QPlainTextEdit(this);
	d_response_edit->setFont(font);
	d_response_edit->setUndoRedoEnabled(false);
	d_response_edit->setLineWrapMode(QPlainTextEdit::NoWrap);
	horizontalLayout->addWidget(d_response_edit);

	this->setWindowTitle(QStringLiteral("Execution Queues"));
}

TExecutionQueueWidget::~TExecutionQueueWidget(void)
{
}

void TExecutionQueueWidget::Clear_Queued_Commands(void)
{
	d_queue_edit->clear();
}

void TExecutionQueueWidget::Add_Queued_Command(
	const QString 						&text)
{
	d_queue_edit->appendPlainText(text);
}

void TExecutionQueueWidget::Clear_Response_Commands(void)
{
	d_response_edit->clear();
}

void TExecutionQueueWidget::Add_Response_Command(
	const QString 						&text)
{
	d_response_edit->appendPlainText(text);
}

