/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QLabel>
#include <QGridLayout>
#include <QSpacerItem>
#include <QFont>
#include <assert.h>

#include "informationwidget.h"

TInformationWidget::TInformationWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QFrame(const_cast<QWidget*>(parent),flags)
{
	QGridLayout							*widget_layout;
	QFont								font;
	int									ival;
	unsigned int						cntr;
		
	ival = font.pointSize() - (1 + TInformationWidget::MAXIMUM_ROW_COUNT / 4);
	if(ival < 7) ival = 7;
	font.setPointSize(ival);
	
	this->setFixedWidth(300);
	
	this->setFrameShape(QFrame::Box);
	this->setFrameShadow(QFrame::Sunken);
	
	widget_layout = new QGridLayout(this);
	widget_layout->setContentsMargins(1,1,1,1);
	widget_layout->setVerticalSpacing(0);
	
	for(cntr = 0;cntr < TInformationWidget::MAXIMUM_ROW_COUNT;++cntr)
	{
		d_name_label[cntr] = new QLabel(this);
		d_name_label[cntr]->setFont(font);
		d_name_label[cntr]->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Preferred));
		d_name_label[cntr]->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
		widget_layout->addWidget(d_name_label[cntr],cntr,0,1,1);
		
		d_value_label[cntr] = new QLabel(this);
		d_value_label[cntr]->setFont(font);
		d_value_label[cntr]->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Preferred));
		widget_layout->addWidget(d_value_label[cntr],cntr,1,1,1);
	}
}

TInformationWidget::~TInformationWidget(void)
{
}

void TInformationWidget::Set_Name_Text(
	const int 							index,
	const QString 						&text)
{
	assert(static_cast<unsigned int>(index) < TInformationWidget::MAXIMUM_ROW_COUNT);
	
	d_name_label[index]->setText(text);
}

void TInformationWidget::Set_Value_Text(
	const int 							index,
	const QString 						&text)
{
	assert(static_cast<unsigned int>(index) < TInformationWidget::MAXIMUM_ROW_COUNT);
	
	d_value_label[index]->setText(text);
}

