/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QComboBox>
#include <QGridLayout>
#include <QLineEdit>
#include <QCheckBox>
#include <QStackedWidget>
#include <QStringList>
#include <QVBoxLayout>
#include <QWidget>
#include <QSizePolicy>
#include <assert.h>

#include "inputwidgetitem.h"

TInputWidgetItem::TInputWidgetItem(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	d_widget_vlayout = new QVBoxLayout(this);
	d_widget_vlayout->setSpacing(0);
	d_widget_vlayout->setContentsMargins(0,0,0,0);

	// defaults;
	d_combo_box = 0;
	d_line_edit = 0;
	d_widget_type = TInputWidgetItem::TYPE_NONE;
}

TInputWidgetItem::~TInputWidgetItem(void)
{
}

QComboBox* TInputWidgetItem::Widget_Combo(void) const
{
	assert(d_combo_box);
	
	return d_combo_box;
}

QLineEdit* TInputWidgetItem::Widget_Edit(void) const
{
	assert(d_line_edit);
	
	return d_line_edit;
}

void TInputWidgetItem::Set_Type(
	const TInputWidgetItem::TWidgetType type)
{
	d_widget_type = type;
	
	if(d_combo_box)
	{
		disconnect(d_combo_box,0,0,0);
		d_widget_vlayout->removeWidget(d_combo_box);
		
		d_combo_box->setVisible(false);
		d_combo_box->deleteLater();
		d_combo_box = 0;
	}
	
	if(d_line_edit)
	{
		disconnect(d_line_edit,0,0,0);
		d_widget_vlayout->removeWidget(d_line_edit);
		
		d_line_edit->setVisible(false);
		d_line_edit->deleteLater();
		d_line_edit = 0;
	}

	switch(d_widget_type)
	{
		case TInputWidgetItem::TYPE_NONE:
			break;
		
		case TInputWidgetItem::TYPE_TEXT:
			
			d_line_edit = new QLineEdit(this);
			d_line_edit->setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);
			d_widget_vlayout->addWidget(d_line_edit);
			break;
			
		case TInputWidgetItem::TYPE_COMBO:
			
			d_combo_box = new QComboBox(this);
			d_combo_box->setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);
			d_widget_vlayout->addWidget(d_combo_box);
			break;
	}
}


