/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef LASEROFFSETDIALOGHEADERFILE
#define LASEROFFSETDIALOGHEADERFILE

#include <QDialog>

class QLineEdit;
class QCheckBox;
class QRadioButton;
class QComboBox;

class TLaserOffsetDialog : public QDialog
{
Q_OBJECT
public:
	
enum TOption
{
	OFFSET_XYZ = 0,
	OFFSET_XYZ_OR_LENGTH
};
	
// CREATORS
	TLaserOffsetDialog(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
	~TLaserOffsetDialog(void);
	
// ACCESSORS
	bool Is_Offset_Position(void) const;
	bool Is_Offset_Length(void) const;
	bool Is_Automove(void) const;
	
	double X(void) const;
	double Y(void) const;
	double Z(void) const;
	double Length(void) const;
	
	bool Offset_From_Start(void) const;
	bool Offset_From_Center(void) const;
	
// MANIPULATORS
	void Reset(const TOption option,const double &length);
	
private slots:
	void Offset_Position_Toggled(bool);
	
private:
	QLineEdit							*d_offset_x_edit;
	QLineEdit							*d_offset_y_edit;
	QLineEdit							*d_offset_z_edit;
	QLineEdit							*d_length_edit;
	QRadioButton						*d_offset_position_radio;
	QRadioButton						*d_update_length_radio;
	QComboBox							*d_update_option_combo;
	QCheckBox							*d_automove_check;

// NOT IMPLEMENTED
	TLaserOffsetDialog(const TLaserOffsetDialog&);
	TLaserOffsetDialog& operator=(const TLaserOffsetDialog&);
};

#endif
