/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef LINKPROTOCOLHEADERFILE
#define LINKPROTOCOLHEADERFILE

#include <QString>
#include <QByteArray>
#include <QHostAddress>
#include <QtNetwork/QTcpSocket>

#include "../../libserialdevice/src/libserialdevice.h"

class QThread;

class TLinkProtocol
{
public:
	
enum TProtocolType
{
	PROTOCOL_NONE=0,
	PROTOCOL_SERIAL,
	PROTOCOL_ETHERNET
};
	
// CREATORS
	TLinkProtocol(const TProtocolType type);
	~TLinkProtocol(void);
	
// ACCESSORS
	TProtocolType Protocol_Type(void) const {return d_protocol_type;}
	
	QString Get_Last_Error(void) const {return d_last_error;}

	qint64 bytesAvailable(void) const;
	qint64 read(char * data, qint64 max_size);
	QByteArray read(qint64 max_size);
		
	
// MANIPULATORS
	void Set_Serial_DeviceName(const QString &name) {d_serial_devicename = name;}
	void Set_Serial_Baud(const TLibSerialDeviceEnum::TBaudRate baud) {d_serial_baud = baud;}
	void Set_Serial_Data(const TLibSerialDeviceEnum::TDataBits data) {d_serial_data = data;}
	void Set_Serial_Parity(const TLibSerialDeviceEnum::TParity parity) {d_serial_parity = parity;}
	void Set_Serial_StopBits(const TLibSerialDeviceEnum::TStopBits stop) {d_serial_stopbits = stop;}
	void Set_Serial_Flow(const TLibSerialDeviceEnum::TFlowControl flow) {d_serial_flow = flow;}
	void Set_Serial_ReadTimeout(const int timeout) {d_serial_readtimeout = timeout;}
	
	void Set_Socket_Hostname(const QString &name) {d_socket_hostname = name;}
	void Set_Socket_Port(const int port) {d_socket_port = port;}
	
	bool Connect(void);
	void Close(void);

	bool getChar(char *c);
	qint64 write(const char *data, qint64 max_size);
	qint64 write(const QByteArray &byte_array);
	
private:
	
	TProtocolType						d_protocol_type;
	LSerialDevice						d_serial_device;
	QTcpSocket							*d_socket_device;
	QThread								*d_socket_device_thread;

	QString								d_serial_devicename;
	TLibSerialDeviceEnum::TBaudRate		d_serial_baud;
	TLibSerialDeviceEnum::TDataBits		d_serial_data;
	TLibSerialDeviceEnum::TParity		d_serial_parity;
	TLibSerialDeviceEnum::TStopBits		d_serial_stopbits;
	TLibSerialDeviceEnum::TFlowControl	d_serial_flow;
	int									d_serial_readtimeout;
	
	QString								d_socket_hostname;
	int									d_socket_port;
	
	mutable QString						d_last_error;
	
// NOT IMPLEMENTED
	TLinkProtocol(void);
	TLinkProtocol(const TLinkProtocol&);
	TLinkProtocol& operator=(const TLinkProtocol&);
};

#endif
