/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QPlainTextEdit>
#include <QTextCursor>
#include <QVBoxLayout>
#include <QFont>

#include "logdialog.h"

TLogDialog::TLogDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QVBoxLayout							*dialog_vlayout;
	QFont								text_font;

	text_font.setFamily(QStringLiteral("Courier New"));
	text_font.setFixedPitch(true);

	this->resize(1001,501);

	dialog_vlayout = new QVBoxLayout(this);

	d_information_edit = new QPlainTextEdit(this);
	d_information_edit->setFont(text_font);
	d_information_edit->setLineWrapMode(QPlainTextEdit::NoWrap);
	d_information_edit->setReadOnly(true);
	dialog_vlayout->addWidget(d_information_edit);

	this->setWindowTitle(QStringLiteral("Communication Log"));

}

TLogDialog::~TLogDialog(void)
{
}

void TLogDialog::Clear_Log(void)
{
	d_information_edit->clear();
}

void TLogDialog::Add_Log_Text(
	const QString						&text)
{
	d_information_edit->moveCursor(QTextCursor::End);
	d_information_edit->appendPlainText(text);
}


