/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFont>
#include <QGridLayout>
#include <QLabel>
#include <QFrame>
#include <QPixmap>
#include <QSpacerItem>

#include "logowidget.h"

TLogoWidget::TLogoWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QGridLayout							*widget_layout;
	QLabel								*logo_label;
	QLabel								*copyright_label;
	QFont								copyright_font;

	copyright_font.setFamily(QStringLiteral("Helvetica"));
	copyright_font.setPointSize(8);
	copyright_font.setItalic(true);

	widget_layout = new QGridLayout(this);
	widget_layout->setContentsMargins(0,0,0,0);

	logo_label = new QLabel(this);
	logo_label->setMinimumSize(100,40);
	logo_label->setMaximumSize(100,40);
	widget_layout->addWidget(logo_label,0,0,1,1);

	copyright_label = new QLabel(this);
	copyright_label->setFont(copyright_font);
	copyright_label->setAlignment(Qt::AlignBottom|Qt::AlignRight|Qt::AlignTrailing);
	widget_layout->addWidget(copyright_label,0,1,1,1);
	
	logo_label->setPixmap(QPixmap(QStringLiteral(":/images/logo.png")));

	copyright_label->setText(QStringLiteral("Copyright (C) 2025 Select Calibration Incorporated.  www.selectcalibration.ca"));
}

TLogoWidget::~TLogoWidget(void)
{
}

