/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREOUTPUTDIALOGHEADERFILE
#define MEASUREOUTPUTDIALOGHEADERFILE

#include <QDialog>

#include "reportwidget.h"

class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QToolButton;

class TMeasureOutputDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TMeasureOutputDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TMeasureOutputDialog(void);

// ACCESSORS
	TReportWidget::TOutputSettings Settings(void) const;

// MANIPULATORS
	void Reset(const QString &application_path,const TReportWidget::TOutputSettings &settings);

signals:

private slots:
	void Path_Option_Changed(void);
	void Browse_Relative_Path(void);
	void Browse_Absolute_Path(void);

private:
	QLabel								*d_application_path_label;
	QLineEdit							*d_absolute_path_edit;
	QLineEdit							*d_relative_path_edit;
	QPushButton							*d_apply_button;
	QRadioButton						*d_absolute_path_check;
	QRadioButton						*d_relative_path_check;
	QToolButton							*d_absolute_path_browse;
	QToolButton							*d_relative_path_browse;
	
	QString								d_application_path;

// NOT IMPLEMENTED
	TMeasureOutputDialog(const TMeasureOutputDialog&);
	TMeasureOutputDialog& operator=(const TMeasureOutputDialog&);
};

#endif
