/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef TYPEHEADERFILE
#define TYPEHEADERFILE

namespace MeasureTypes
{
	
enum TDisplayCoordinateSystem
{
	COORDINATE_SYSTEM_MACHINE = 0,
	COORDINATE_SYSTEM_PART,
	COORDINATE_SYSTEM_PART_ORIGIN_ONLY
};

enum TConfiguration
{
	MEASURE_NULL=0,
	MEASURE_STEPGAUGE_10360,
	MEASURE_STEPGAUGE_B89,
	MEASURE_STEPGAUGE_SQUARE,
	MEASURE_GAUGEBLOCK,
	MEASURE_SPHERE_PFTU,
	MEASURE_BALLBAR_B89,
	MEASURE_BALLBAR_10360,
	MEASURE_RINGGAUGE,
	MEASURE_PINGAUGE,
	MEASURE_POINT_REPEAT,
	MEASURE_SPHERE_REPEAT,
	MEASURE_ROLL_OFFSET_TOOL,
	CALIBRATE_TOOLS
};
	
enum TStepgaugeType
{
	STEPGAUGE_NULL = 0,
	STEPGAUGE_CHECKMASTER,
	STEPGAUGE_STARRET,
	STEPGAUGE_KOBA
};

enum TSequenceFunction
{
	SEQUENCE_NULL = 0,
	SEQUENCE_INIT_ROLL,
	SEQUENCE_CHANGE_TOOL_ROLL,
	SEQUENCE_MOVE_CLEAR_ROLL,
	SEQUENCE_ALIGN_STEPGAUGE_MANUAL,
	SEQUENCE_ALIGN_GAUGEBLOCK_MANUAL,
	SEQUENCE_ALIGN_POINT_MANUAL,
	SEQUENCE_ALIGN_SPHERE_MANUAL,
	SEQUENCE_ALIGN_SPHERE_MANUAL_CALIBRATION,
	SEQUENCE_ALIGN_BALLBAR_B89_MANUAL,
	SEQUENCE_ALIGN_BALLBAR_10360_MANUAL,
	SEQUENCE_ALIGN_RINGGAUGE_MANUAL,
	SEQUENCE_ALIGN_PINGAUGE_MANUAL,
	SEQUENCE_ALIGN_STEPGAUGE_DCC,
	SEQUENCE_ALIGN_GAUGEBLOCK_DCC,
	SEQUENCE_ALIGN_POINT_DCC,
	SEQUENCE_ALIGN_SPHERE_DCC,
	SEQUENCE_ALIGN_BALLBAR_B89_DCC,
	SEQUENCE_ALIGN_BALLBAR_10360_DCC,
	SEQUENCE_ALIGN_RINGGAUGE_DCC,
	SEQUENCE_ALIGN_PINGAUGE_DCC,
	SEQUENCE_MEASURE_STEPGAUGE_10360,
	SEQUENCE_MEASURE_STEPGAUGE_B89,
	SEQUENCE_MEASURE_STEPGAUGE_SQUARE,
	SEQUENCE_MEASURE_GAUGE_BLOCK,
	SEQUENCE_MEASURE_POINT_REPEAT,
	SEQUENCE_MEASURE_SPHERE_REPEAT,
	SEQUENCE_MEASURE_SPHERE_PFTU,
	SEQUENCE_MEASURE_BALLBAR_B89,
	SEQUENCE_MEASURE_BALLBAR_10360,
	SEQUENCE_MEASURE_RINGGAUGE,
	SEQUENCE_MEASURE_PINGAUGE,
	SEQUENCE_MEASURE_ROLL_SPHERE,
	SEQUENCE_REPORT_STEPGAUGE_10360,
	SEQUENCE_REPORT_STEPGAUGE_B89,
	SEQUENCE_REPORT_STEPGAUGE_SQUARE,
	SEQUENCE_REPORT_GAUGEBLOCK,
	SEQUENCE_REPORT_POINT_REPEAT,
	SEQUENCE_REPORT_SPHERE_REPEAT,
	SEQUENCE_REPORT_SPHERE_PFTU,
	SEQUENCE_REPORT_BALLBAR_B89,
	SEQUENCE_REPORT_BALLBAR_10360,
	SEQUENCE_REPORT_RINGGAUGE,
	SEQUENCE_REPORT_PINGAUGE,
	SEQUENCE_REPORT_ROLL,
	SEQUENCE_REPORT_TOOLS,
	SEQUENCE_CALIBRATE_TOOLS
};

enum TAlignmentOptions
{
	ALIGNMENT_FULL = 0,
	ALIGNMENT_SKIP_MANUAL,
	ALIGNMENT_SKIP_MANUAL_AND_DCC,
	ALIGNMENT_ONLY
};
};

#endif
