/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MEASUREDIRECTHEADERFILE
#define MEASUREDIRECTHEADERFILE

#include <QMainWindow>

class QCloseEvent;
class QTimer;
class QSettings;

class TCMMWidget;
class TSettingsWidget;
class TToolWidget;
class TMeasureWidget;
class TReportWidget;
class TLogoWidget;
class TMeasureDialog;
class TLaserDialog;
class TExerciseDialog;
class TLinkDialog;
class TDriver;
class TMessageBox;

class TMeasureDirect : public QMainWindow
{
Q_OBJECT

public:

// CREATORS
	TMeasureDirect(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TMeasureDirect(void);

// ACCESSORS

// MANIPULATORS

signals:

private slots:
	
	void Calibrate_Tools(void);
	void Change_Tool(const QString &name);
	void Refresh_Tools(void);
	void Move_Position(const double&,const double&, const double&);
	
	void Machine_Settings_Changed(void);
	void Thermal_Settings_Changed(void);
	void Artifact_Settings_Changed(void);
	void Request_Sensor_IDs(void);
	void Request_Sensor_Value(int);

	void Pause_Driver(void);
	void Resume_Driver(void);
	void Stop_Driver(void);
	void Driver_Ended(void);

	void CMM_Connect(void);
	void CMM_Disconnect(void);
	void CMM_Home(void);
	void CMM_Exercise_Machine(void);

	void Measure_Sequence_Start(void);
	void Measure_Sequence_End(void);
	void Measure_Refresh_Temperatures(void);
	void Measure_Update_Part_Expansion_Coefficient(const double&);
	void Measure_Update_Tip_Diameter(const QString&,const double&, const double&, const double&);	// tool_base_name, a,b,tip_diameter
	void Measure_Stepgauge_10360(void);
	void Measure_Stepgauge_B89(void);
	void Measure_Stepgauge_Square(void);
	void Measure_Ballbar(void);
	void Measure_Ballbar_10360(void);
	void Measure_Gaugeblock(void);
	void Measure_Sphere_Pftu(void);
	void Measure_Ringgauge(void);
	void Measure_Pingauge(void);
	void Measure_Sphere_Repeat(void);
	void Measure_Point_Repeat(void);
	void Measure_Roll(void);
	void Measure_Laser(void);

	void Laser_Set_Tool_Data(const double&,const double&,const double&,const double&);// xyzd
	void Laser_Sequence_Start(void);
	void Laser_Sequence_End(void);
	
	void Driver_Connecting(void);
	void Driver_Connected(void);
	void Driver_Update_Machine_State(const bool show_warning);
	void Driver_Position(const double&,const double&,const double&);	// xyz
	void Driver_Touch_Point(const double&,const double&,const double&,const double&,const double&,const double&);	// xyzijk
	void Driver_Event(const QString&);
	void Driver_Error(const QString&,const int);
	void Driver_Key_Done(void);
	void Driver_Key_Erase_Hit(void);
	void Driver_Query_Tool_Data(const QString &name,const double &x,const double &y,const double &z,const double &i,const double &j,const double &k,const double &d);
	void Driver_Tool_Index_Confirmation_AB(const double&, const double&,int *  const state);	// AB Angles, result.  Must be Qt::BlockingQueuedConnection
	void Driver_Tool_Index_Confirmation_Name(const QString&,int *  const state);				// Name, result.  Must be Qt::BlockingQueuedConnection
	void Driver_Tool_Name_Changed(const QString &name);
	void Driver_Tool_Update_Error(void);
	void Driver_Approach_Distance(const double&);
	void Driver_Sync(const int);
	void Driver_Temperature_X(const double&);
	void Driver_Temperature_Y(const double&);
	void Driver_Temperature_Z(const double&);
	void Driver_Temperature_Part(const double&);
	void Driver_Sensor_Value(int,const double&);
	void Driver_Sensors_X(const QString&);
	void Driver_Sensors_Y(const QString&);
	void Driver_Sensors_Z(const QString&);
	void Driver_Sensors_Part(const QString&);
	void Driver_Clear_Ipp_Tools(void);
	void Driver_Add_Ipp_Tool(const QString&);
	void Driver_Add_Ipp_Tools_Complete(void);
	
	void Exercise_Sequence_Start(void);
	void Exercise_Sequence_Cancel(void);
	void Exercise_Sequence_End(void);
	void Exercise_Get_Position(void);

	void Process_Queued_Commands(void);		// Calls to this function must be serialized.

protected:
	virtual void closeEvent(QCloseEvent *event);

private:

	TCMMWidget							*d_cmm_widget;
	TSettingsWidget						*d_settings_widget;
	TToolWidget							*d_tool_widget;
	TMeasureWidget						*d_measure_widget;
	TReportWidget						*d_report_widget;
	TLogoWidget							*d_logo_widget;
	TMeasureDialog						*d_measure_dialog;
	TLaserDialog						*d_laser_dialog;
	TExerciseDialog						*d_exercise_dialog;
	TLinkDialog							*d_link_dialog;
	TMessageBox							*d_message_box;

	QTimer								*d_process_timer;
	QSettings							*d_settings;
	QString								d_application_path;
	QString								d_data_path;

	TDriver								*d_driver;
	bool								d_close_on_thread_finish;

// NOT IMPLEMENTED
	TMeasureDirect(const TMeasureDirect&);
	TMeasureDirect& operator=(const TMeasureDirect&);
};

#endif
