/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef NAMEEDITDIALOGHEADERFILE
#define NAMEEDITDIALOGHEADERFILE

#include <QDialog>
#include <QStringList>

class QLabel;
class QLineEdit;
class QPushButton;

class TNameEditDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TNameEditDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TNameEditDialog(void);

// ACCESSORS
	QString Name(void) const;

// MANIPULATORS
	void Reset(const QString &dialog_title,const QString &parameter_name,const QStringList &existing_names);

signals:

private slots:
	void Name_Changed(const QString&);

private:
	QLabel								*d_name_label;
	QLineEdit							*d_name_edit;
	QPushButton							*d_accept_button;
	
	QStringList							d_existing_names;

// NOT IMPLEMENTED
	TNameEditDialog(const TNameEditDialog&);
	TNameEditDialog& operator=(const TNameEditDialog&);
};

#endif
