/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef SETTINGSWIDGETHEADERFILE
#define SETTINGSWIDGETHEADERFILE

#include <QWidget>

#include "controller.h"

class TIconWidget;
class TSettingsMachineDialog;
class TSettingsArtifactDialog;
class TMeasureOutputDialog;
class TInformationWidget;

class TSettingsWidget : public QWidget
{
Q_OBJECT

public:
	
enum TThermalCompensationMode
{
	CONTROLLER_THERMAL_COMPENSATION_OFF = 0,
	CONTROLLER_THERMAL_COMPENSATION_ACTIVE
};
	
enum TBlendedMoveMode
{
	BLENDED_MOVE_IGNORED = 0,
	BLENDED_MOVE_ENABLE,
	BLENDED_MOVE_DISABLE
};
	
struct TMachineSettings
{
	double								move_speed;
	double								acceleration;
	double								touch_speed;
	double								approach_distance;
	double								expansion_coeff_x;
	double								expansion_coeff_y;
	double								expansion_coeff_z;
	QString								sensors_x;
	QString								sensors_y;
	QString								sensors_z;
	QString								sensors_part;
	TThermalCompensationMode			thermal_compensation_mode;
	TBlendedMoveMode					blended_move_mode;
};
	
struct TArtifactSettings
{
	double								sg_checkmaster_pln_x_start;
	double								sg_checkmaster_pln_x_end;
	double								sg_checkmaster_pln_y1;
	double								sg_checkmaster_pln_y2;
	double								sg_checkmaster_ln_x_start;
	double								sg_checkmaster_ln_x_end;
	double								sg_checkmaster_ln_z;
	double								sg_checkmaster_pnt_y;
	double								sg_checkmaster_pnt_z;
	double								sg_checkmaster_clear_z;
	
	double								sg_webber_clear_z;
	
	double								sg_koba_pln_x_start;
	double								sg_koba_pln_x_end;
	double								sg_koba_pln_y1;
	double								sg_koba_pln_y2;
	double								sg_koba_ln_x_start;
	double								sg_koba_ln_x_end;
	double								sg_koba_ln_z;
	double								sg_koba_pnt_y;
	double								sg_koba_pnt_z;
	double								sg_koba_clear_probe;

	double								gaugeblock_pln_y;
	double								gaugeblock_pln_z;
	double								gaugeblock_pln_sp;
	double								gaugeblock_clear_z;
	double								ballbar_clear_distance;
	double								ballbar_avoidance_angle;
	double								ballbar_10360_clear_distance;
	int									ballbar_10360_sphere_points;
	double								ringgauge_clear_z;
	double								ringgauge_pln_offset;
	double								ringgauge_cir_z;
	double								pingauge_clear_z;
	double								pingauge_pln_offset;
	double								pingauge_cir_z;
	double								plane_sample_radius;
	double								roll_clear_z;
	int									roll_sphere_points;
	double								calibration_sphere_clear_z;
	int									calibration_sphere_points;
};
	

// CREATORS
	TSettingsWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TSettingsWidget(void);

// ACCESSORS
	TSettingsWidget::TMachineSettings Machine_Settings(void) const;
	TSettingsWidget::TArtifactSettings Artifact_Settings(void) const;
	
// MANIPULATORS
	void Reset(TController::TControllerType controller_type);
//	void Disconnected(void);

	void Set_Machine_Settings(const TSettingsWidget::TMachineSettings &settings);
	void Set_Artifact_Settings(const TSettingsWidget::TArtifactSettings &settings);
	
	void Set_Temperature_Sensors_X(const QString &sensors);
	void Set_Temperature_Sensors_Y(const QString &sensors);
	void Set_Temperature_Sensors_Z(const QString &sensors);
	void Set_Temperature_Sensors_Part(const QString &sensors);
	
signals:
	void Machine_Settings_Changed(void);
	void Artifact_Settings_Changed(void);
	void Request_Sensor_IDs(void);

private slots:
	void Change_Machine_Settings(void);
	void Change_Artifact_Settings(void);

private:
	
	TIconWidget							*d_machine_settings_option;
	TIconWidget							*d_artifact_settings_option;
	TSettingsMachineDialog				*d_settings_machine_dialog;
	TSettingsArtifactDialog				*d_settings_artifact_dialog;
	TInformationWidget					*d_information_widget;

	TController::TControllerType		d_controller_type;
	TMachineSettings					d_machine_settings;
	TArtifactSettings					d_artifact_settings;
	
	int									d_move_speed_index;
	int									d_touch_speed_index;
	int									d_acceleration_index;
	int									d_approach_distance_index;
	int									d_cte_x_index;
	int									d_cte_y_index;
	int									d_cte_z_index;

	void Update_Widget_Display(void);

// NOT IMPLEMENTED
	TSettingsWidget(const TSettingsWidget&);
	TSettingsWidget& operator=(const TSettingsWidget&);
};

#endif
