/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFrame>
#include <QGridLayout>
#include <QLabel>
#include <QSizePolicy>
#include <QSpacerItem>

#include "tempcompinformationdialog.h"

TTempcompInformationDialog::TTempcompInformationDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QFrame								*lower_hsepator_line;
	QFrame								*upper_hseparator_line;
	QGridLayout							*dialog_layout;
	QLabel								*part_cte_label;
	QLabel								*part_temperature_label;
	QLabel								*x_cte_label;
	QLabel								*x_scale_label;
	QLabel								*x_temperature_label;
	QLabel								*y_cte_label;
	QLabel								*y_scale_label;
	QLabel								*y_temperature_label;
	QLabel								*z_cte_label;
	QLabel								*z_scale_label;
	QLabel								*z_temperature_label;
	QSizePolicy							size_policy_minexp_preferred(QSizePolicy::MinimumExpanding,QSizePolicy::Preferred);
	QSpacerItem							*dialog_vspacer;

	size_policy_minexp_preferred.setHorizontalStretch(0);
	size_policy_minexp_preferred.setVerticalStretch(0);

	this->resize(312,274);
	this->setModal(false);

	dialog_layout = new QGridLayout(this);

	x_temperature_label = new QLabel(this);
	dialog_layout->addWidget(x_temperature_label,0,0,1,1);

	d_x_temperature_label = new QLabel(this);
	d_x_temperature_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_x_temperature_label,0,1,1,1);

	y_temperature_label = new QLabel(this);
	dialog_layout->addWidget(y_temperature_label,1,0,1,1);

	d_y_temperature_label = new QLabel(this);
	d_y_temperature_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_y_temperature_label,1,1,1,1);

	z_temperature_label = new QLabel(this);
	dialog_layout->addWidget(z_temperature_label,2,0,1,1);

	d_z_temperature_label = new QLabel(this);
	d_z_temperature_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_z_temperature_label,2,1,1,1);

	part_temperature_label = new QLabel(this);
	dialog_layout->addWidget(part_temperature_label,3,0,1,1);

	d_part_temperature_label = new QLabel(this);
	d_part_temperature_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_part_temperature_label,3,1,1,1);

	upper_hseparator_line = new QFrame(this);
	upper_hseparator_line->setFrameShape(QFrame::HLine);
	upper_hseparator_line->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(upper_hseparator_line,4,0,1,2);

	x_cte_label = new QLabel(this);
	dialog_layout->addWidget(x_cte_label,5,0,1,1);

	d_x_cte_label = new QLabel(this);
	d_x_cte_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_x_cte_label,5,1,1,1);

	y_cte_label = new QLabel(this);
	dialog_layout->addWidget(y_cte_label,6,0,1,1);

	d_y_cte_label = new QLabel(this);
	d_y_cte_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_y_cte_label,6,1,1,1);

	z_cte_label = new QLabel(this);
	dialog_layout->addWidget(z_cte_label,7,0,1,1);

	d_z_cte_label = new QLabel(this);
	d_z_cte_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_z_cte_label,7,1,1,1);

	part_cte_label = new QLabel(this);
	dialog_layout->addWidget(part_cte_label,8,0,1,1);

	d_part_cte_label = new QLabel(this);
	d_part_cte_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_part_cte_label,8,1,1,1);

	lower_hsepator_line = new QFrame(this);
	lower_hsepator_line->setFrameShape(QFrame::HLine);
	lower_hsepator_line->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(lower_hsepator_line,9,0,1,2);

	x_scale_label = new QLabel(this);
	dialog_layout->addWidget(x_scale_label,10,0,1,1);

	d_x_scale_label = new QLabel(this);
	d_x_scale_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_x_scale_label,10,1,1,1);

	y_scale_label = new QLabel(this);
	dialog_layout->addWidget(y_scale_label,11,0,1,1);

	d_y_scale_label = new QLabel(this);
	d_y_scale_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_y_scale_label,11,1,1,1);

	z_scale_label = new QLabel(this);
	dialog_layout->addWidget(z_scale_label,12,0,1,1);

	d_z_scale_label = new QLabel(this);
	d_z_scale_label->setSizePolicy(size_policy_minexp_preferred);
	dialog_layout->addWidget(d_z_scale_label,12,1,1,1);

	dialog_vspacer = new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	dialog_layout->addItem(dialog_vspacer,13,0,1,2);
	
	// defaults
	d_update_scale = false;
	
	this->Set_Temperature_X(20.0);
	this->Set_Temperature_Y(20.0);
	this->Set_Temperature_Z(20.0);
	this->Set_Temperature_Part(20.0);
	
	this->Set_CTE_X(10.0);
	this->Set_CTE_Y(10.0);
	this->Set_CTE_Z(10.0);
	this->Set_CTE_Part(10.0);
	
	this->Set_Scale_X(1.0);
	this->Set_Scale_Y(1.0);
	this->Set_Scale_Z(1.0);

	this->setWindowTitle(QStringLiteral("Temperature Compensation"));
	
	y_scale_label->setText(QStringLiteral("Y Axis Scale Factor:"));
	z_scale_label->setText(QStringLiteral("Z Axis Scale Factor:"));
	part_temperature_label->setText(QStringLiteral("Part Temperature:"));
	x_cte_label->setText(QStringLiteral("Effective X CTE:"));
	z_temperature_label->setText(QStringLiteral("Z Temperature:"));
	x_temperature_label->setText(QStringLiteral("X Temperature:"));
	part_cte_label->setText(QStringLiteral("Part CTE:"));
	y_temperature_label->setText(QStringLiteral("Y Temperature:"));
	y_cte_label->setText(QStringLiteral("Effective Y CTE:"));
	x_scale_label->setText(QStringLiteral("X Axis Scale Factor:"));
	z_cte_label->setText(QStringLiteral("Effective Z CTE:"));
}

TTempcompInformationDialog::~TTempcompInformationDialog(void)
{
}

void TTempcompInformationDialog::Set_Temperature_X(
	const double 						&d)
{
	d_x_temperature_label->setText(QString("%1 ˚C").arg(d,0,'f',2));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_Temperature_Y(
	const double 						&d)
{
	d_y_temperature_label->setText(QString("%1 ˚C").arg(d,0,'f',2));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_Temperature_Z(
	const double 						&d)
{
	d_z_temperature_label->setText(QString("%1 ˚C").arg(d,0,'f',2));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_Temperature_Part(
	const double 						&d)
{
	d_part_temperature_label->setText(QString("%1 ˚C").arg(d,0,'f',2));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_CTE_X(
	const double 						&d)
{
	d_x_cte_label->setText(QString("%1 um/m/˚C").arg(d,0,'f',1));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_CTE_Y(
	const double 						&d)
{
	d_y_cte_label->setText(QString("%1 um/m/˚C").arg(d,0,'f',1));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_CTE_Z(
	const double 						&d)
{
	d_z_cte_label->setText(QString("%1 um/m/˚C").arg(d,0,'f',1));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_CTE_Part(
	const double 						&d)
{
	d_part_cte_label->setText(QString("%1 um/m/˚C").arg(d,0,'f',1));
	d_update_scale = true;
}

void TTempcompInformationDialog::Set_Scale_X(
	const double 						&d)
{
	d_x_scale_label->setText(QString("%1").arg(d,0,'f',9));
	d_update_scale = false;
}

void TTempcompInformationDialog::Set_Scale_Y(
	const double 						&d)
{
	d_y_scale_label->setText(QString("%1").arg(d,0,'f',9));
	d_update_scale = false;
}

void TTempcompInformationDialog::Set_Scale_Z(
	const double 						&d)
{
	d_z_scale_label->setText(QString("%1").arg(d,0,'f',9));
	d_update_scale = false;
}

