/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef TEMPERATUREMONITORDIALOGHEADERFILE
#define TEMPERATUREMONITORDIALOGHEADERFILE

#include <QDialog>
#include <QFile>
#include <vector>

class QDoubleSpinBox;
class QToolButton;
class QWidget;
class QSpacerItem;
class QHBoxLayout;
class QTimer;
class QShowEvent;
class QHideEvent;
class TGaugeWidget;

class TTemperatureMonitorDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TTemperatureMonitorDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TTemperatureMonitorDialog(void);

// ACCESSORS
	double Lower_Temperature_Limit(void) const;
	double Upper_Temperature_Limit(void) const;

// MANIPULATORS
	void Set_Lower_Temperature_Limit(const double &value);
	void Set_Upper_Temperature_Limit(const double &value);
	
	void Set_Sensor_Value(int sensor_id,const double &value,const QString &log_path);
	
	void Set_Temperature_Sensors_X(const QString &sensors);
	void Set_Temperature_Sensors_Y(const QString &sensors);
	void Set_Temperature_Sensors_Z(const QString &sensors);
	void Set_Temperature_Sensors_Part(const QString &sensors);
	
	void Enable_Log_Option(void);
	void Disable_Log_Option(void);

signals:
	void Request_Sensor_Value(int);
	void Temperature_Limits_Changed(void);

private slots:
	void Hide_Dialog(void);
	void Min_Value_Changed(double);
	void Max_Value_Changed(double);
	void Update_Sensors(void);
	
protected:
	virtual void showEvent(QShowEvent *event);
	virtual void hideEvent(QHideEvent *event);

private:
	QDoubleSpinBox						*d_lower_limit_spin;
	QDoubleSpinBox						*d_upper_limit_spin;
	QToolButton							*d_write_log_button;
	TGaugeWidget						*d_part_temperature_gauge;
	TGaugeWidget						*d_x_temperature_gauge;
	TGaugeWidget						*d_y_temperature_gauge;
	TGaugeWidget						*d_z_temperature_gauge;
	QWidget								*d_part_sensors_area_widget;
	QWidget								*d_x_sensors_area_widget;
	QWidget								*d_y_sensors_area_widget;
	QWidget								*d_z_sensors_area_widget;
	QHBoxLayout							*d_x_sensors_hlayout;
	QHBoxLayout							*d_y_sensors_hlayout;
	QHBoxLayout							*d_z_sensors_hlayout;
	QHBoxLayout							*d_part_sensors_hlayout;
	QWidget								*d_part_sensors_spacer_widget;
	QWidget								*d_x_sensors_spacer_widget;
	QWidget								*d_y_sensors_spacer_widget;
	QWidget								*d_z_sensors_spacer_widget;
	
	QFile								d_temperature_log_file;
	QTimer								*d_update_timer;
	int									d_update_item_cntr;
	
	std::vector<TGaugeWidget*>			d_x_sensors;
	std::vector<TGaugeWidget*>			d_y_sensors;
	std::vector<TGaugeWidget*>			d_z_sensors;
	std::vector<TGaugeWidget*>			d_part_sensors;
	
	
	void Add_X_Sensor(const int id);
	void Add_Y_Sensor(const int id);
	void Add_Z_Sensor(const int id);
	void Add_Part_Sensor(const int id);
	
	void Remove_X_Sensor(const int id);
	void Remove_Y_Sensor(const int id);
	void Remove_Z_Sensor(const int id);
	void Remove_Part_Sensor(const int id);
	
	void Remove_X_Sensors(void);
	void Remove_Y_Sensors(void);
	void Remove_Z_Sensors(void);
	void Remove_Part_Sensors(void);

	void Update_All_Sensors(void);
	
	bool Open_Temperature_Log(const QString &file_name);
	bool Write_Temperature_Log(int sensor_id,const double &temperature);


// NOT IMPLEMENTED
	TTemperatureMonitorDialog(const TTemperatureMonitorDialog&);
	TTemperatureMonitorDialog& operator=(const TTemperatureMonitorDialog&);
};

#endif
