/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFrame>
#include <QHBoxLayout>
#include <QLabel>
#include <QSizePolicy>

#include "titlewidget.h"

TTitleWidget::TTitleWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QFrame								*left_line;
	QFrame								*right_line;
	QHBoxLayout							*widget_layout;
	QSizePolicy							sizepolicy_minexpanding_fixed(QSizePolicy::MinimumExpanding, QSizePolicy::Fixed);
	
	sizepolicy_minexpanding_fixed.setHorizontalStretch(0);
	sizepolicy_minexpanding_fixed.setVerticalStretch(0);

	widget_layout = new QHBoxLayout(this);
	widget_layout->setContentsMargins(0,0,0,0);

	left_line = new QFrame(this);
	left_line->setMinimumSize(50,0);
	left_line->setMaximumSize(50,16777215);
	left_line->setFrameShape(QFrame::HLine);
	left_line->setFrameShadow(QFrame::Sunken);
	widget_layout->addWidget(left_line);

	d_title_label = new QLabel(this);
	widget_layout->addWidget(d_title_label);

	right_line = new QFrame(this);
	sizepolicy_minexpanding_fixed.setHeightForWidth(right_line->sizePolicy().hasHeightForWidth());
	right_line->setSizePolicy(sizepolicy_minexpanding_fixed);
	right_line->setFrameShape(QFrame::HLine);
	right_line->setFrameShadow(QFrame::Sunken);
	widget_layout->addWidget(right_line);
}

TTitleWidget::~TTitleWidget(void)
{
}

QString TTitleWidget::Text(void) const
{
	return d_title_label->text();
}

void TTitleWidget::Set_Text(
	const QString						&text)
{
	d_title_label->setText(text);
}

