/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef TOOLADDANGLESDIALOGHEADERFILE
#define TOOLADDANGLESDIALOGHEADERFILE

#include <QDialog>
#include <vector>
#include <set>

class QLabel;
class QPlainTextEdit;
class QLineEdit;
class QPushButton;

class TToolAddAnglesDialog : public QDialog
{
Q_OBJECT

public:

struct TAngle
{
	double								angle_a;
	double								angle_b;
};

// CREATORS
	TToolAddAnglesDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TToolAddAnglesDialog(void);

// ACCESSORS
	std::vector<TAngle> Angles(void) const {return d_angles;}

// MANIPULATORS
	void Reset(void);

signals:

private slots:
	void Add_Angle(void);
	void Add_Angles(void);

private:
	QPlainTextEdit						*d_angle_list_edit;
	QLineEdit							*d_angle_a_edit;
	QLineEdit							*d_angle_b_edit;
	QLineEdit							*d_end_a_edit;
	QLineEdit							*d_end_b_edit;
	QLineEdit							*d_increment_a_edit;
	QLineEdit							*d_increment_b_edit;
	QLineEdit							*d_start_a_edit;
	QLineEdit							*d_start_b_edit;
	QPushButton							*d_accept_button;
	
	std::vector<TAngle>					d_angles;
	std::set<int>						d_angle_signatures;
	
	int Angle_Signature(const double &angle_a,const double &angle_b);
	void Update_Angle_List(void);


// NOT IMPLEMENTED
	TToolAddAnglesDialog(const TToolAddAnglesDialog&);
	TToolAddAnglesDialog& operator=(const TToolAddAnglesDialog&);
};

#endif
