/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include "toolbuilderdata.h"

TToolBuilderData::TToolBuilderData(void)
{
	this->Initialize_Components();
}

TToolBuilderData::~TToolBuilderData(void)
{
}

std::vector<TToolBuilderData::TComponent> TToolBuilderData::Connection_Components(
	const TToolBuilderData::TConnectionType connection_type) const
{
	std::vector<TToolBuilderData::TComponent> components;
	std::vector<TToolBuilderData::TComponent>::const_iterator iter;
	
	for(iter = d_components.begin();iter != d_components.end();++iter)
	{
		if((*iter).connection_required == connection_type)
		{
			components.push_back(*iter);
		}
	}
	
	return components;
}

TVector3 TToolBuilderData::Get_Fixed_Offset(
	const QString						&name,
	const TConnectionType				connection_required,
	const TConnectionType				connection_provides) const
{
	TVector3							offset;
	std::vector<TToolBuilderData::TComponent>::const_iterator iter;
	
	for(iter = d_components.begin();iter != d_components.end();++iter)
	{
		if((*iter).connection_required == connection_required &&
		   (*iter).connection_provides == connection_provides &&
		   (*iter).name == name)
		{
			offset = (*iter).fixed_offset;
			break;
		}
	}
	
	return offset;
}

TVector3 TToolBuilderData::Get_Rotational_Offset(
	const QString						&name,
	const TConnectionType				connection_required,
	const TConnectionType				connection_provides) const
{
	TVector3							offset;
	std::vector<TToolBuilderData::TComponent>::const_iterator iter;
	
	for(iter = d_components.begin();iter != d_components.end();++iter)
	{
		if((*iter).connection_required == connection_required &&
		   (*iter).connection_provides == connection_provides &&
		   (*iter).name == name)
		{
			offset = (*iter).rotational_offset;
			break;
		}
	}
	
	return offset;
}

void TToolBuilderData::Initialize_Components(void)
{
	TToolBuilderData::TComponent		component;
	
	// todo.  put component data in external file allowing easy customization

	d_components.clear();
	
	// heads
	component.component_type = TToolBuilderData::COMPONENT_PROBE_HEAD;
	component.connection_required = TToolBuilderData::CONNECT_CMM;

	component.name = QStringLiteral("Ren MH8");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,43);
	component.rotational_offset.Set(-5.7,0,21);
	d_components.push_back(component);

	component.name = QStringLiteral("Ren PH8");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,49.5);
	component.rotational_offset.Set(0,0,22);
	d_components.push_back(component);

	component.name = QStringLiteral("Ren PH9");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,77);
	component.rotational_offset.Set(0,0,25);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Ren PH9A");
	component.connection_provides = TToolBuilderData::CONNECT_RENISHAW_PAA1;
	component.fixed_offset.Set(0,0,79);
	component.rotational_offset.Set(0,0,38.52);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Ren PH10T");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,77);
	component.rotational_offset.Set(0,0,25);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Ren PH10M");
	component.connection_provides = TToolBuilderData::CONNECT_RENISHAW_PAA1;
	component.fixed_offset.Set(0,0,78.55);
	component.rotational_offset.Set(0,0,38.52);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Ren PH10MQ");
	component.connection_provides = TToolBuilderData::CONNECT_RENISHAW_PAA1;
	component.fixed_offset.Set(0,0,35);
	component.rotational_offset.Set(0,0,38.52);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-A-M7.5");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,67.5);
	component.rotational_offset.Set(0,0,49);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-A-T7.5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,67.5);
	component.rotational_offset.Set(0,0,46.2);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-AS8-M7.5");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,44.4);
	component.rotational_offset.Set(0,0,49);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-AS8-T7.5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,44.4);
	component.rotational_offset.Set(0,0,46.2);
	d_components.push_back(component);

	component.name = QStringLiteral("Hex HH-A-M5");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,67.5);
	component.rotational_offset.Set(12,0,48.5);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-A-T5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,67.5);
	component.rotational_offset.Set(12,0,45.7);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-AS6-M5");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,44.4);
	component.rotational_offset.Set(12,0,48.5);
	d_components.push_back(component);
		
	component.name = QStringLiteral("Hex HH-AS8-M5");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,44.4);
	component.rotational_offset.Set(12,0,48.5);
	d_components.push_back(component);

	component.name = QStringLiteral("Hex HH-AS6-T5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,44.4);
	component.rotational_offset.Set(12,0,45.7);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-AS8-T5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,44.4);
	component.rotational_offset.Set(12,0,45.7);
	d_components.push_back(component);

	component.name = QStringLiteral("Hex HH-A-T2.5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,101.9);
	component.rotational_offset.Set(0,0,46.8);
	d_components.push_back(component);
	
	component.name = QStringLiteral("Hex HH-AS-T2.5");
	component.connection_provides = TToolBuilderData::CONNECT_HEXAGON_TK;
	component.fixed_offset.Set(0,0,65.2);
	component.rotational_offset.Set(0,0,46.8);
	d_components.push_back(component);

	
	// renishaw quick connects
	component.component_type = TToolBuilderData::COMPONENT_QUICK_CONNECT;
	component.connection_required = TToolBuilderData::CONNECT_RENISHAW_PAA1;

	component.name = QStringLiteral("PAA1");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,30);
	d_components.push_back(component);
	
	component.name = QStringLiteral("PAA2");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,140);
	d_components.push_back(component);
	
	component.name = QStringLiteral("PAA3");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,300);
	d_components.push_back(component);
	
	// hexagon quick connects
	component.component_type = TToolBuilderData::COMPONENT_QUICK_CONNECT;
	component.connection_required = TToolBuilderData::CONNECT_HEXAGON_TK;

	component.name = QStringLiteral("TKJ_31");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,31.3);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TKJ_140");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,140.5);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TKJ_300");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,300.5);
	d_components.push_back(component);

	component.name = QStringLiteral("TKJ_450");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,450);
	d_components.push_back(component);

	
	// extensions
	component.component_type = TToolBuilderData::COMPONENT_EXTENSION;
	component.connection_required = TToolBuilderData::CONNECT_M8;

	component.name = QStringLiteral("EXT50");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,50);
	d_components.push_back(component);

	component.name = QStringLiteral("EXT100");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,100);
	d_components.push_back(component);
	
	component.name = QStringLiteral("EXT200");
	component.connection_provides = TToolBuilderData::CONNECT_M8;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,200);
	d_components.push_back(component);

	
	// special case probes
	component.name = QStringLiteral("DEA TF8");
	component.component_type = TToolBuilderData::COMPONENT_PROBE;
	component.connection_required = TToolBuilderData::CONNECT_CMM;
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,60);
	component.rotational_offset.Set(0,0,0);
	d_components.push_back(component);

	// m8 probes
	component.component_type = TToolBuilderData::COMPONENT_PROBE;
	component.connection_required = TToolBuilderData::CONNECT_M8;

	component.name = QStringLiteral("TP2");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,38);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TP20");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,38);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TP20 EM1");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,88);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TP20 EM2");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,113);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TP200");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,43);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TP6");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,46.5);
	d_components.push_back(component);
	
	component.name = QStringLiteral("HP-TM");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,37.1);
	d_components.push_back(component);
	
	component.name = QStringLiteral("HP-T");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,26.3);
	d_components.push_back(component);
	
	component.name = QStringLiteral("HP-T-RP");
	component.connection_provides = TToolBuilderData::CONNECT_STYLUS;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,41);
	d_components.push_back(component);

	
	
	// stylus
	component.component_type = TToolBuilderData::COMPONENT_STYLUS;
	component.connection_required = TToolBuilderData::CONNECT_STYLUS;

	component.name = QStringLiteral("TIPX10");
	component.connection_provides = TToolBuilderData::CONNECT_TIP;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,10);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TIPX20");
	component.connection_provides = TToolBuilderData::CONNECT_TIP;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,20);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TIPX21");
	component.connection_provides = TToolBuilderData::CONNECT_TIP;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,21);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TIPX30");
	component.connection_provides = TToolBuilderData::CONNECT_TIP;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,30);
	d_components.push_back(component);
	
	component.name = QStringLiteral("TIPX40");
	component.connection_provides = TToolBuilderData::CONNECT_TIP;
	component.fixed_offset.Set(0,0,0);
	component.rotational_offset.Set(0,0,40);
	d_components.push_back(component);
}
