/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef TOOLBUILDERDATAHEADERFILE
#define TOOLBUILDERDATAHEADERFILE

#include <QString>
#include <vector>

#include "../../../core/vector3.h"

class TToolBuilderData
{
public:
 
enum TConnectionType
{
	CONNECT_NOTHING = 0,
	CONNECT_CMM,
	CONNECT_RENISHAW_PAA1,
	CONNECT_HEXAGON_TK,
	CONNECT_M8,
	CONNECT_STYLUS,
	CONNECT_TIP
};
	
enum TComponentType
{
	COMPONENT_CMM = 0,
	COMPONENT_PROBE_HEAD,
	COMPONENT_QUICK_CONNECT,
	COMPONENT_EXTENSION,
	COMPONENT_PROBE,
	COMPONENT_STYLUS
};
	
struct TComponent
{
	QString								name;
	TConnectionType						connection_required;
	TConnectionType						connection_provides;
	TComponentType						component_type;
	TVector3							fixed_offset;
	TVector3							rotational_offset;
};
	
// CREATORS
	TToolBuilderData(void);
	~TToolBuilderData(void);
	
// ACCESSORS
	std::vector<TComponent> Connection_Components(const TConnectionType connection_type) const;
	
	TVector3 Get_Fixed_Offset(const QString &name,const TConnectionType connection_required,const TConnectionType connection_provides) const;
	TVector3 Get_Rotational_Offset(const QString &name,const TConnectionType connection_required,const TConnectionType connection_provides) const;
	

// MANIPULATORS
	
private:
	
	std::vector<TComponent>				d_components;
	
	void Initialize_Components(void);
	
// NOT IMPLEMENTED
	TToolBuilderData(const TToolBuilderData&);
	TToolBuilderData& operator=(const TToolBuilderData&);
};

#endif
