/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef TOOLWIDGETHEADERFILE
#define TOOLWIDGETHEADERFILE

#include <QWidget>
#include <QStringList>
#include <vector>

#include "controller.h"

class QLabel;

class TIconWidget;
class TToolUtilitiesDialog;
class TXmlFile;
class TInformationWidget;

class TToolWidget : public QWidget
{
Q_OBJECT

public:
	
struct TToolItem
{
	QString								name;
	double								angle_a;
	double								angle_b;
	double								tip_diameter;
	TVector3							xyz;
	TVector3							ijk;
};
	
// CREATORS
	TToolWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TToolWidget(void);

// ACCESSORS
	bool Active_Tool_Valid(void) const {return d_active_tool_valid;}
	QString Active_Tool_Name(void) const;

	bool Is_Motorized_Probe_Head(void) const;
	
	bool Save_Tool_Data(const QString &path) const;
	QStringList Get_Tool_List(void) const;
	
	QString Calibration_Tool_Name(void) const {return d_calibration_tool_name;}
	TToolItem Tool_Item(const QString &name,bool * const valid) const;
	std::vector<TToolItem> Calibration_Tool_Items(void) const {return d_calibration_tool_items;}

// MANIPULATORS
	void Reset(TController::TControllerType controller_type);
	void Set_Active_Tool_Name(const QString &name);

	void Clear_Ipp_Tools(void);
	void Add_Ipp_Tool(const QString &name);
	void Update_Ipp_Tool(const TToolWidget::TToolItem &item);

	bool Load_Tool_Data(const QString &path);
	void Update_Tool_Tip_Diameter(const QString &tool_base_name,const double &angle_a,const double &angle_b, const double &tip_diameter);
	void Update_Tool_Information(const TToolItem &tool_item);
	void Update_Tool_Information_Offsets(const double &x,const double &y,const double &z);

// Static
	static QString Format_Tool_Name(const QString &tool_base_name,const double &angle_a,const double &angle_b);
	static bool Extract_Tool_Name_Data(const QString &tool_name,QString * const tool_base_name,double * const angle_a,double * const angle_b);

signals:
	void Calibrate_Tools(void);
	void Refresh_Tools(void);

public slots:
	void Invalidate_Active_Tool(void);

private slots:
	void Tool_Item_Clicked(void);

private:
	TIconWidget							*d_tool_utilities_widget;
	TIconWidget							*d_refresh_tools_widget;
	TToolUtilitiesDialog				*d_tool_utilities_dialog;
	TInformationWidget					*d_information_widget;

	TController::TControllerType		d_controller_type;
	std::vector<TToolItem>				d_ipp_tool_items;
	std::vector<TToolItem>				d_calibration_tool_items;
	QString								d_calibration_tool_name;
	
	bool								d_active_tool_valid;
	QString								d_active_tool_name;
	double								d_active_tool_angle_a;
	double								d_active_tool_angle_b;

	int									d_tool_name_index;
	int									d_tool_offset_x_index;
	int									d_tool_offset_y_index;
	int									d_tool_offset_z_index;
	int									d_tool_diam_index;
	

// NOT IMPLEMENTED
	TToolWidget(const TToolWidget&);
	TToolWidget& operator=(const TToolWidget&);
};

#endif
