/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef VALIDATIONDIALOGHEADERFILE
#define VALIDATIONDIALOGHEADERFILE

#include <QDialog>
#include <QFile>
#include <vector>
#include <random>

#include "../../../core/vector3.h"

class QSpinBox;
class QToolButton;
class TMessageBox;

class TValidationDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TValidationDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TValidationDialog(void);

// ACCESSORS

// MANIPULATORS
	void Reset(const QString &output_path);

signals:

private slots:
	void Min_Points_Changed(int);
	
	void Generate_Line(void);
	void Generate_Plane(void);
	void Generate_Circle(void);
	void Generate_Sphere(void);

private:
	QSpinBox							*d_max_points_spin;
	QSpinBox							*d_min_points_spin;
	QSpinBox							*d_total_sets_spin;
	QToolButton							*d_generate_circle_button;
	QToolButton							*d_generate_line_button;
	QToolButton							*d_generate_plane_button;
	QToolButton							*d_generate_sphere_button;
	TMessageBox							*d_message_box;

	std::mt19937						d_random_engine;
	
	QString								d_output_path;
	QFile								d_output_file;

	void Output_Line_Results(const int index,std::vector<TVector3> &pnts);
	void Output_Plane_Results(const int index,std::vector<TVector3> &pnts);
	void Output_Circle_Results(const int index,std::vector<TVector3> &pnts,const TVector3 &axis);
	void Output_Sphere_Results(const int index,std::vector<TVector3> &pnts);
	
	TVector3 Random_Axis(void);
	double Random(void);
	double Random(const double &max_value);
	int Random(const int max_count);
	
// NOT IMPLEMENTED
	TValidationDialog(const TValidationDialog&);
	TValidationDialog& operator=(const TValidationDialog&);
};

#endif
