/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QTextStream>

#include "measuredata.h"

TMeasureData::TMeasureData(void)
{
	d_file_type = TMeasureData::TYPE_UNKNOWN;
}

TMeasureData::~TMeasureData(void)
{
}

TMeasureData::TFileType TMeasureData::Determine_File_Contents(
	const QByteArray					&file_data)
{
	TMeasureData::TFileType				type(TMeasureData::TYPE_UNKNOWN);
	TMeasureData::TFileEncoding			encoding;
	QString								header_line;
	
	encoding = TMeasureData::Determine_File_Encoding(file_data);
	
	if(encoding == TMeasureData::FILE_ASCII)
	{
		QTextStream						stream(file_data,QIODevice::ReadOnly);
		
		if(!stream.atEnd())
		{
			header_line = stream.readLine().trimmed();
			
			if(header_line.startsWith(QStringLiteral("B89.4.10360_Raw_Measurement:Version=2:Type=Five_Gauge")))
			{
				type = TMeasureData::TYPE_STEPGAUGE_10360;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.1_Raw_Measurement:Version=1:Type=Step_Gauge")))
			{
				type = TMeasureData::TYPE_STEPGAUGE_B89;
			}
			else if(header_line.startsWith(QStringLiteral("Stepgauge_Raw_Measurement:Version=1:Type=Squareness")))
			{
				type = TMeasureData::TYPE_STEPGAUGE_SQUARE;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.10360_Raw_Measurement:Version=1:Type=Single_Gauge")))
			{
				type = TMeasureData::TYPE_GAUGEBLOCK;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.10360_Raw_Measurement:Version=2:Type=Sphere_Repeat")))
			{
				type = TMeasureData::TYPE_SPHERE_RPT;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.10360_Raw_Measurement:Version=1:Type=Sphere_Pftu")))
			{
				type = TMeasureData::TYPE_SPHERE_PFTU;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.1_Data:Version=1:Type=BallBar")))
			{
				type = TMeasureData::TYPE_BALLBAR;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.10360_Raw_Measurement:Version=1:Type=BallBar_10360")))
			{
				type = TMeasureData::TYPE_BALLBAR_10360;
			}
			else if(header_line.startsWith(QStringLiteral("Artifact_Measurement:Version=1:Type=Point_Repeat")))
			{
				type = TMeasureData::TYPE_POINT_REPEAT;
			}
			else if(header_line.startsWith(QStringLiteral("Artifact_Measurement:Version=1:Type=Ring_Gauge")))
			{
				type = TMeasureData::TYPE_RINGGAUGE;
			}
			else if(header_line.startsWith(QStringLiteral("Artifact_Measurement:Version=1:Type=Pin_Gauge")))
			{
				type = TMeasureData::TYPE_PINGAUGE;
			}
			else if(header_line.startsWith(QStringLiteral("Artifact_Measurement:Version=1:Type=Roll_Offset_Tool")))
			{
				type = TMeasureData::TYPE_ROLL_OFFSET_TOOL;
			}
			else if(header_line.startsWith(QStringLiteral("Artifact_Measurement:Version=1:Type=Tip_Calibration")))
			{
				type = TMeasureData::TYPE_PROBE_CALIBRATION;
			}
			else if(header_line.startsWith(QStringLiteral("Artifact_Measurement:Version=2:Type=Tip_Calibration")))
			{
				type = TMeasureData::TYPE_PROBE_CALIBRATION;
			}
			else if(header_line.startsWith(QStringLiteral("Temperature_Log:Version=1:Type=Machine_Sensors")))
			{
				type = TMeasureData::TYPE_TEMPERATURE_LOG;
			}
			else if(header_line.startsWith(QStringLiteral("B89.4.10360_Raw_Measurement:Version=1:Type=Machine_And_Laser")))
			{
				type = TMeasureData::TYPE_MACHINE_LASER_10360;
			}
			else if(header_line.startsWith(QStringLiteral("PMove_Raw_Measurement:Version=1:Type=Machine_And_Laser")))
			{
				type = TMeasureData::TYPE_MACHINE_LASER_PMOVE;
			}
			else if(header_line.startsWith(QStringLiteral("Best_Fit_Validation:Version=1:Type=Sphere")))
			{
				type = TMeasureData::TYPE_VALIDATION_SPHERE;
			}
			else if(header_line.startsWith(QStringLiteral("Best_Fit_Validation:Version=1:Type=Plane")))
			{
				type = TMeasureData::TYPE_VALIDATION_PLANE;
			}
			else if(header_line.startsWith(QStringLiteral("Best_Fit_Validation:Version=1:Type=Circle")))
			{
				type = TMeasureData::TYPE_VALIDATION_CIRCLE;
			}
			else if(header_line.startsWith(QStringLiteral("Best_Fit_Validation:Version=1:Type=Line")))
			{
				type = TMeasureData::TYPE_VALIDATION_LINE;
			}
		}
	}
	
	return type;
}

TMeasureData::TFileEncoding TMeasureData::Determine_File_Encoding(
	const QByteArray					&file_data)
{
	TMeasureData::TFileEncoding			encoding(TMeasureData::FILE_ASCII);
	QByteArray::const_iterator			iter;
	char								data_byte;
	
	for(iter = file_data.begin();iter != file_data.end();++iter)
	{
		data_byte = (*iter);
		
		if(data_byte != 0x0d &&
		   data_byte != 0x0a &&
		   data_byte != 0x09 &&
		   data_byte < 0x20)
		{
			encoding = TMeasureData::FILE_BINARY;
			break;
		}
	}

	return encoding;
}
