/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATA_BALLBAR10360HEADERFILE
#define MEASUREDATA_BALLBAR10360HEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "measuredata.h"

class TMeasureBallbar10360 : public TMeasureData
{
public:
	// CREATORS
	TMeasureBallbar10360(void);
	virtual ~TMeasureBallbar10360(void);
	
	// ACCESSORS
	
	virtual QString Equipment_Identification(void) const {return d_equipment_identification;}
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
	// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	
	virtual bool Set_Nominal_Data(const std::vector<TVector3> &data);

private:
	
struct TSphereData
{
	TVector3							actual;
	TVector3							nominal;
};
	
struct TLengthData
{
	double								nominal;
	double								actual;
};
	
	TVector3							d_scale_expansion_coefficient;
	QString								d_equipment_identification;
	QString								d_measurement_description;
	int									d_sphere_zero_offset;
	double								d_temperature_x;
	double								d_temperature_y;
	double								d_temperature_z;
	double								d_temperature_gauge;
	std::vector<TSphereData>			d_sphere_data;
	std::vector<TLengthData>			d_length_data;
	
	void Update_Length_Data(void);
	
	TVector3 Get_Nominal(const TVector3 &position,const std::vector<TVector3> &data,bool * const valid) const;
	
	// NOT IMPLEMENTED
	TMeasureBallbar10360(const TMeasureBallbar10360&);
	TMeasureBallbar10360& operator=(const TMeasureBallbar10360&);
};

#endif
