/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MEASUREDATA_MACHINELASERPMOVEHEADERFILE
#define MEASUREDATA_MACHINELASERPMOVEHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "measuredata.h"

class TMeasureMachineLaserPMove : public TMeasureData
{
public:
// CREATORS
	TMeasureMachineLaserPMove(void);
	virtual ~TMeasureMachineLaserPMove(void);
	
// ACCESSORS
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	
	
private:
	
friend struct Sort_Functor_Position;

struct TMeasuredData
{
	double								nominal_target;
	double								actual_target;
	double								laser_value;
	double								deviation;
	TVector3							position;
	int									index;			// secondary identification of data
};

enum TMeasurementType
{
	MEASUREMENT_SCALE = 0,
	MEASUREMENT_STRAIGHTNESS_X,
	MEASUREMENT_STRAIGHTNESS_Y,
	MEASUREMENT_STRAIGHTNESS_Z,
	MEASUREMENT_ANGULAR
};
	
	TVector3							tool_offset;
	TVector3							d_start_point;
	TVector3							d_measurement_axis;
	QString								d_measurement_description;
	TMeasurementType					d_measurement_type;
	std::vector<TMeasuredData>			d_measured_data;
	std::vector<TVector2>				d_point_data;
	
	void Combine_Points(void);
	
// NOT IMPLEMENTED
	TMeasureMachineLaserPMove(const TMeasureMachineLaserPMove&);
	TMeasureMachineLaserPMove& operator=(const TMeasureMachineLaserPMove&);
};

#endif
