/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATA_POINTREPEATHEADERFILE
#define MEASUREDATA_POINTREPEATHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "measuredata.h"

class TMeasurePointRepeat : public TMeasureData
{
public:
	// CREATORS
	TMeasurePointRepeat(void);
	virtual ~TMeasurePointRepeat(void);
	
	// ACCESSORS
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
	// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	
private:
	
	QString								d_measurement_description;
	double								d_move_distance;
	TVector3							tool_offset;
	TVector3							d_probe_data_vector;
	std::vector<TVector3>				d_points;
	
	// NOT IMPLEMENTED
	TMeasurePointRepeat(const TMeasurePointRepeat&);
	TMeasurePointRepeat& operator=(const TMeasurePointRepeat&);
};

#endif
