/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATA_ROLLOFFSETTOOLHEADERFILE
#define MEASUREDATA_ROLLOFFSETTOOLHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "measuredata.h"

class TMeasureRollOffsetTool : public TMeasureData
{
public:
	// CREATORS
	TMeasureRollOffsetTool(void);
	virtual ~TMeasureRollOffsetTool(void);
	
	// ACCESSORS
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
	// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	
private:
	
	TVector3							d_tool1_offset;
	TVector3							d_tool1_vector;
	TVector3							d_tool2_offset;
	TVector3							d_tool2_vector;
	TVector3							d_sphere1_tool1;
	TVector3							d_sphere1_tool2;
	TVector3							d_sphere2_tool1;
	TVector3							d_sphere2_tool2;
	double								d_sphere1_tool1_diameter;
	double								d_sphere1_tool2_diameter;
	double								d_sphere2_tool1_diameter;
	double								d_sphere2_tool2_diameter;
	double								d_sphere1_tool1_form;
	double								d_sphere1_tool2_form;
	double								d_sphere2_tool1_form;
	double								d_sphere2_tool2_form;
	
	// NOT IMPLEMENTED
	TMeasureRollOffsetTool(const TMeasureRollOffsetTool&);
	TMeasureRollOffsetTool& operator=(const TMeasureRollOffsetTool&);
};

#endif
