/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATA_STEPGAUGEB89HEADERFILE
#define MEASUREDATA_STEPGAUGEB89HEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "measuredata.h"

class TMeasureStepgaugeB89 : public TMeasureData
{
public:
// CREATORS
	TMeasureStepgaugeB89(void);
	virtual ~TMeasureStepgaugeB89(void);
	
// ACCESSORS
	
	virtual QString Equipment_Identification(void) const {return d_equipment_identification;}
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	virtual bool Set_Nominal_Data(const std::vector<TVector3> &data);
	
private:
		
struct TPointData
{
	double								nominal;
	double								actual;
};
	
struct TAnalysisData
{
	double								nominal;
	double								min;
	double								max;
	double								mean;
	double								std_dev;
	std::vector<double>					actual;
};

	TVector3							d_scale_expansion_coefficient;
	QString								d_equipment_identification;
	QString								d_measurement_description;
	double								d_reference_step_position;
	double								d_temperature_x;
	double								d_temperature_y;
	double								d_temperature_z;
	double								d_temperature_gauge;
	std::vector<TPointData>				d_point_data;
	std::vector<TAnalysisData>			d_analysis_data;
		
	double Get_Nominal(const double &position,const std::vector<TVector3> &data,bool * const valid) const;
	void Create_Analysis_Data(void);
	bool Calculate_Stats(const std::vector<double> &data,double * const min,double * const max, double * const average,double * const std_dev) const;
	
	// NOT IMPLEMENTED
	TMeasureStepgaugeB89(const TMeasureStepgaugeB89&);
	TMeasureStepgaugeB89& operator=(const TMeasureStepgaugeB89&);
};

#endif
