/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREDATA_STEPGAUGESQUAREHEADERFILE
#define MEASUREDATA_STEPGAUGESQUAREHEADERFILE

#include <vector>

#include "../../../core/vector2.h"

#include "measuredata.h"

class TMeasureStepgaugeSquare : public TMeasureData
{
public:
	// CREATORS
	TMeasureStepgaugeSquare(void);
	virtual ~TMeasureStepgaugeSquare(void);
	
	// ACCESSORS
	
	virtual QString Equipment_Identification(void) const {return d_equipment_identification;}
	
	virtual QStringList Text_Report(void) const;
	virtual std::vector<std::vector<TVector2> > Graph_Data(void) const;
	
	// MANIPULATORS
	virtual bool Load_Data(const QByteArray &file_data);
	
	virtual bool Set_Nominal_Data(const std::vector<TVector3> &data);
	
private:
	
friend struct TPointData_Sort;

struct TPointData
{
	double								nominal;
	double								actual;
};

struct TLengthData
{
	double								nominal;
	double								actual;
};
	
	QString								d_equipment_identification;
	QString								d_measurement_description;
	double								d_reference_step_position;
	double								d_error_gradient;
	double								d_error_y_intercept;
	std::vector<TPointData>				d_point_data;
	std::vector<TLengthData>			d_length_data;
	
	void Consolidate_Points(void);
	void Update_Length_Data(void);
	
	double Get_Nominal(const double &position,const std::vector<TVector3> &data,bool * const valid) const;
	
	// NOT IMPLEMENTED
	TMeasureStepgaugeSquare(const TMeasureStepgaugeSquare&);
	TMeasureStepgaugeSquare& operator=(const TMeasureStepgaugeSquare&);
};

#endif
