/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef MEASUREDWIDGETHEADERFILE
#define MEASUREDWIDGETHEADERFILE

#include <QWidget>

class QListWidget;
class QToolButton;
class TMeasuredInputDialog;

class TMeasuredWidget : public QWidget
{
Q_OBJECT

public:
	
struct TInputSettings
{
	QString								input_relative_path;
	QString								input_absolute_path;
	bool								use_relative_path;
};


// CREATORS
	TMeasuredWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TMeasuredWidget(void);

// ACCESSORS
	TMeasuredWidget::TInputSettings Input_Settings(void) const;
	QString File_Path(void) const {return d_data_path;}

// MANIPULATORS
	void Set_Input_Settings(const TMeasuredWidget::TInputSettings &settings);
	void Refresh_File_List(void);

signals:
	void Load_Data(const QString&);							// file name
	void Remove_Data(const QString&, const QStringList&);	// filepath, filenames;
	void File_Path_Changed(void);

private slots:
	void Remove_Clicked(void);
	void Edit_Clicked(void);
	void Refresh_Clicked(void);
	
	void Selection_Changed(void);

private:
	QListWidget							*d_measured_list;
	QToolButton							*d_remove_button;
	QToolButton							*d_edit_button;
	QToolButton							*d_refresh_button;
	TMeasuredInputDialog				*d_measured_input_dialog;
	
	QString								d_application_path;
	QString								d_data_path;

	TInputSettings						d_input_settings;
	
	void Update_Display(void);


// NOT IMPLEMENTED
	TMeasuredWidget(const TMeasuredWidget&);
	TMeasuredWidget& operator=(const TMeasuredWidget&);
};

#endif
