/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef NOMINALWIDGETHEADERFILE
#define NOMINALWIDGETHEADERFILE

#include <QWidget>

#include "../../core/vector3.h"

#include "nominaleditordialog.h"

class QListWidget;
class QToolButton;
class TXmlFile;
class TMessageBox;

class TNominalWidget : public QWidget
{
Q_OBJECT

public:
	
// CREATORS
	TNominalWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TNominalWidget(void);

// ACCESSORS
	std::vector<TVector3> Nominal_Data(const QString &serial,bool * const valid);

// MANIPULATORS
	void Initialize(const QString &data_path);

signals:

private slots:
	void Add_Nominal(void);
	void Remove_Nominal(void);
	void Edit_Nominal(void);
	void Selection_Changed(void);

private:
	QListWidget							*d_nominal_list;
	QToolButton							*d_add_button;
	QToolButton							*d_edit_button;
	QToolButton							*d_remove_button;
	TNominalEditorDialog				*d_nominal_editor_dialog;
	TMessageBox							*d_message_box;
	
	QString								d_data_path;
	
	std::vector<TVector3>				d_active_data;
	QString								d_active_serial_number;
	TNominalEditorDialog::TNominalType	d_nominal_type;
	
	void Update_Display(void);
	
	bool Load_Data(const QString &name);
	bool Save_Data(const QString &name);
	void Remove_Data(const QString &name);
	
	void Load_Data_V1(TXmlFile * const xml_file);
	void Load_Data_V2(TXmlFile * const xml_file);

// NOT IMPLEMENTED
	TNominalWidget(const TNominalWidget&);
	TNominalWidget& operator=(const TNominalWidget&);
};

#endif
