/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef RPMSPECSEDITORHEADERFILE
#define RPMSPECSEDITORHEADERFILE

#include <QMainWindow>

class QAction;
class QTabWidget;
class QSettings;
class QCloseEvent;
class QTimer;

class TVariablesWidget;
class TExpressionsWidget;
class TLibrariesWidget;
class TRequiresWidget;
class TChangeLogWidget;
class TOptionsWidget;
class TMessageBox;

class TRPMSpecsEditor : public QMainWindow
{
Q_OBJECT

public:

// CREATORS
	TRPMSpecsEditor(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TRPMSpecsEditor(void);

// ACCESSORS

// MANIPULATORS

signals:

private slots:
	void File_Create_Spec_File(void);
	void File_Save_Spec_Data(void);
	void File_Open_Spec_Data(void);
	void Help_About(void);
	void Update_Requirements(void) const;
	void Update_Option_Shared_Libs_Path(const QString &path);
	
	void Write_Spec_File(void) const;
	
protected:
	virtual void closeEvent(QCloseEvent *event);

private:
	QAction								*d_quit_action;
	QAction								*d_create_action;
	QAction								*d_save_action;
	QAction								*d_open_action;
	QAction								*d_about_action;
	QTabWidget							*d_widget_tab;
	
	TVariablesWidget					*d_variables_widget;
	TExpressionsWidget					*d_expressions_widget;
	TLibrariesWidget					*d_libraries_widget;
	TRequiresWidget						*d_requires_widget;
	TChangeLogWidget					*d_changelog_widget;
	TOptionsWidget						*d_options_widget;
	
	QSettings							*d_settings;
	QTimer								*d_write_specfile_timer;
	TMessageBox							*d_msg_box;

	QString								d_data_path;
	QString								d_working_path;
	QString								d_file_name;
	
	mutable QString						d_last_error;
	
	bool Write_Spec_Data_File(const QString &file_name) const;
	bool Read_Spec_Data_File(const QString &file_name);

// NOT IMPLEMENTED
	TRPMSpecsEditor(const TRPMSpecsEditor&);
	TRPMSpecsEditor& operator=(const TRPMSpecsEditor&);
};

#endif
