/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QApplication>
#include <QFrame>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSpacerItem>

#include "variableeditordialog.h"

TVariableEditorDialog::TVariableEditorDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QFrame								*separator_hline;
	QGridLayout							*dialog_layout;
	QHBoxLayout							*button_hlayout;
	QLabel								*name_label;
	QLabel								*value_label;
	QSpacerItem							*button_hspacer;
	QSpacerItem							*dialog_vspacer;


	this->resize(400,181);

	dialog_layout = new QGridLayout(this);

	name_label = new QLabel(this);
	dialog_layout->addWidget(name_label,0,0,1,1);

	d_name_edit = new QLineEdit(this);
	dialog_layout->addWidget(d_name_edit,0,1,1,1);

	value_label = new QLabel(this);
	dialog_layout->addWidget(value_label,1,0,1,1);

	d_value_edit = new QLineEdit(this);
	dialog_layout->addWidget(d_value_edit,1,1,1,1);

	separator_hline = new QFrame(this);
	separator_hline->setFrameShape(QFrame::HLine);
	separator_hline->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(separator_hline,2,0,1,2);

	dialog_vspacer = new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	dialog_layout->addItem(dialog_vspacer,3,0,1,2);

	button_hlayout = new QHBoxLayout();

	button_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	button_hlayout->addItem(button_hspacer);

	d_cancel_button = new QPushButton(this);
	d_cancel_button->setAutoDefault(false);
	button_hlayout->addWidget(d_cancel_button);

	d_accept_button = new QPushButton(this);
	d_accept_button->setAutoDefault(true);
	button_hlayout->addWidget(d_accept_button);
	dialog_layout->addLayout(button_hlayout,4,0,1,2);
	
	// defaults
	d_accept_button->setEnabled(false);

	this->setWindowTitle(QStringLiteral("Variable Editor"));
	name_label->setText(QStringLiteral("Name:"));
	value_label->setText(QStringLiteral("Value:"));
	d_cancel_button->setText(QStringLiteral("Cancel"));
	d_accept_button->setText(QStringLiteral("Accept"));
	
	connect(d_name_edit,&QLineEdit::textChanged,this,&TVariableEditorDialog::Validate);
	connect(d_cancel_button,&QPushButton::clicked,this,&TVariableEditorDialog::reject);
	connect(d_accept_button,&QPushButton::clicked,this,&TVariableEditorDialog::accept);
}

TVariableEditorDialog::~TVariableEditorDialog(void)
{
}

QString TVariableEditorDialog::Name(void) const
{
	return d_name_edit->text();
}

QString TVariableEditorDialog::Value(void) const
{
	return d_value_edit->text();
}

void TVariableEditorDialog::Validate(
	const QString						&text)
{
	d_accept_button->setEnabled(false);
		
	if(text.length())
	{
		d_accept_button->setEnabled(true);
	}
}



