/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QString>
#include <assert.h>

#include "libcmakelistsimpl.h"
#include "libcmakelists.h"

LCMakeLists::LCMakeLists(void)
{
	d_cmakelists_impl = new TCMakeListsImpl;
}

LCMakeLists::~LCMakeLists(void)
{
	delete d_cmakelists_impl;
}

QString LCMakeLists::Last_Error(void) const
{
	return d_cmakelists_impl->Last_Error();
}

bool LCMakeLists::Write_CMakeLists(
	const QString						&file_name)
{
	return d_cmakelists_impl->Write_CMakeLists(file_name);
}

bool LCMakeLists::Load_QMake(
	const QString						&file_name)
{
	return d_cmakelists_impl->Load_QMake(file_name);
}



