/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef LIBCMAKELISTSHEADERFILE
#define LIBCMAKELISTSHEADERFILE

#include <QString>

#if defined CONFIGURE_DLL_EXPORT
#define DLL_EXPORT_CONFIGURE  Q_DECL_EXPORT
#else
#define DLL_EXPORT_CONFIGURE Q_DECL_IMPORT
#endif

class TCMakeListsImpl;

class DLL_EXPORT_CONFIGURE LCMakeLists
{
public:
	
// CREATORS
	LCMakeLists(void);
	~LCMakeLists(void);
	
// ACCESSORS
	QString Last_Error(void) const;
	
	bool Write_CMakeLists(const QString &file_name);

// MANIPULATORS
	bool Load_QMake(const QString &file_name);

private:
	
	TCMakeListsImpl						*d_cmakelists_impl;		// compilation firewall

// NOT IMPLEMENTED
	LCMakeLists(const LCMakeLists&);
	LCMakeLists& operator=(const LCMakeLists&);
};

#endif
