/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef LIBCMAKELISTSIMPLHEADERFILE
#define LIBCMAKELISTSIMPLHEADERFILE

#include <QString>
#include <QStringList>
#include <vector>

class TCMakeListsImpl
{
public:
// CREATORS
	TCMakeListsImpl(void);
	~TCMakeListsImpl(void);
	
// ACCESSORS
	QString Last_Error(void) const {return d_last_error;}
	
	bool Write_CMakeLists(const QString &file_name);

// MANIPULATORS
	bool Load_QMake(const QString &file_name);

private:
	
enum TProjectType
{
	PROJECT_SUBDIRS = 0,
	PROJECT_APPLICATION,
	PROJECT_LIBRARY
};
	

struct TEntry
{
	QString								scope_name;
	QString								name;
	QStringList							values;
};
		
	std::vector<TEntry>					d_entries;
	QStringList							d_scope_names;
	QStringList							d_cmake_lines;

	mutable QString						d_last_error;
	
	bool Load_QMake_Include_File(const QString &root_path,const QString &file_name);

	void Expand_QMake(void);
	QStringList Expand_QMake(const QStringList &qmake_lines) const;
	
	bool Is_Qt_Scope_Name(const QString &name) const;
	QStringList Get_CMake_Scope_Names(const QString &qmake_scope_name) const;
	QStringList Get_Parameter_Names(const QString &line) const;				// return list of names inside round braces
	QString Get_Module_Name(const QString &name) const;
	bool Has_Scope(const QString &name) const;
	bool Has_Entry(const QString &scope_name,const QString &name) const;
	bool Has_Entry_Value(const QString &scope_name,const QString &name,const QString &value) const;
	TEntry Get_Entry(const QString &scope_name,const QString &name,bool * const valid) const;
	TProjectType Get_Project_Type(void) const;
	int Get_Project_SubDir_Dir_Count(void) const;

	void Add_Entry(const TEntry &entry);
	void Add_Entry(const TEntry &entry,const QStringList &scope_names);
	void Remove_Entry_Values(const TEntry &entry);
	void Remove_Entry_Values(const TEntry &entry,const QStringList &scope_names);
	
	bool Initialize_CMakeList_Data(const TCMakeListsImpl::TProjectType project_type);
	bool Process_Global_Libs(void);
	bool Process_Sources(const TCMakeListsImpl::TProjectType project_type);
	bool Process_Scoped_Sources(const QString &scope_name);
	bool Process_Scoped_Libraries(const QString &target_name,const bool has_sources,const bool has_headers,const bool has_resources,const bool has_forms);
	bool Process_CMake_Target_Link_Libraries(void);
	bool Process_SubDirs(void);
	bool Process_Linux_Entries(const TCMakeListsImpl::TProjectType project_type);
	bool Process_Apple_Entries(const TCMakeListsImpl::TProjectType project_type);
	bool Process_Unix_Entries(const TCMakeListsImpl::TProjectType project_type);
	bool Process_Windows_Entries(const TCMakeListsImpl::TProjectType project_type);
	bool Finalize_CMakeList_Data(const TCMakeListsImpl::TProjectType project_type);
		
// NOT IMPLEMENTED
	TCMakeListsImpl(const TCMakeListsImpl&);
	TCMakeListsImpl& operator=(const TCMakeListsImpl&);
};

#endif
