/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef SOURCETREEHEADERFILE
#define SOURCETREEHEADERFILE

#include <QDialog>
#include <vector>
#include <set>

#include "../../libcmakelists/src/libcmakelists.h"

class QLineEdit;
class QCheckBox;
class QPushButton;
class QToolButton;
class QTreeWidget;
class QPlainTextEdit;
class QSettings;
class QDragEnterEvent;
class QDropEvent;
class QCloseEvent;
class TMessageBox;

class TSourceTree : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TSourceTree(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TSourceTree(void);

// ACCESSORS

// MANIPULATORS

signals:

private slots:
	void Browse_Project_File(void);
	void Browse_Output_Directory(void);
	void Browse_Readme_File(void);
	void Load(void);
	void Readme_Check_Toggled(bool);
	void Create_Output(void);
	
protected:
	virtual void dragEnterEvent(QDragEnterEvent *DragEnterEvent);
	virtual void dropEvent(QDropEvent *DropEvent);
	virtual void closeEvent(QCloseEvent *event);


private:
	QLineEdit							*d_information_name_edit;
	QLineEdit							*d_information_project_edit;
	QLineEdit							*d_information_version_edit;
	QLineEdit							*d_output_directory_edit;
	QLineEdit							*d_output_readme_edit;
	QCheckBox							*d_output_toplevel_project_check;
	QCheckBox							*d_output_readme_check;
	QPushButton							*d_create_button;
	QPushButton							*d_load_button;
	QToolButton							*d_information_project_browse_button;
	QToolButton							*d_output_directory_browse_button;
	QToolButton							*d_output_readme_browse_button;
	QTreeWidget							*d_sources_tree;
	QPlainTextEdit						*d_log_text;
	QSettings							*d_settings;
	TMessageBox							*d_msg_box;

	QString								d_data_path;
	QString								d_default_path;
	QString								d_target_path;
	std::set<QString>					d_path_directories;
	std::set<QString>					d_file_list;
	std::vector<QString>				d_project_list;
	LCMakeLists							d_cmake_lists;

	mutable QString						d_last_error;
	
	void Load_Project(const QString &file_name);
	bool Load_Qt_Project_File(const QString &file_path,const QString &file_name);
	
	void Clear_Log(void);
	void Add_Log_Text(const QString &text);
	void Scroll_Log_Top(void);
	
	QString Get_Directory_Of_File(const QString &file_name) const;
	QString	Get_Project_Name(const QString &file_name) const;	// returns only the file name without a path
	QString Search_Project_Name(const QString &path) const;
	
	void Add_Project_Name(const QString &project_name);
	
	std::vector<QString> Get_Sub_Directories(const QString &file_name) const;
	std::vector<QString> Get_Project_Dependencies(const QString &file_name) const;
	std::vector<QString> Get_File_List_Qt_Project(const QString &file_name) const;
	std::vector<QString> Get_File_List_Qt_Resource(const QString &file_name) const;
	std::vector<QString> Get_File_List_Qt_Include(const QString &file_name) const;
	std::vector<QString> Get_File_List_Win_Resource(const QString &file_name) const;
	
	void Create_Directory_Entries(void);
	void Create_Toplevel_Project(const QString &target_path);
	void Add_Readme(const QString &target_path);

// NOT IMPLEMENTED
	TSourceTree(const TSourceTree&);
	TSourceTree& operator=(const TSourceTree&);
};

#endif
