/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef OPENGLSHADERSHEADERFILE
#define OPENGLSHADERSHEADERFILE

namespace OpenGLShaders
{
	static const char *triangle_vertex_shader =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   uniform vec4 color;\n"
	"   uniform vec3 offset;\n"
	"   uniform float specular;\n"
	"   attribute vec3 vertex;\n"
	"   attribute vec3 normal;\n"
	"   varying float vertex_angle;\n"
	"   varying float vertex_specular;\n"
	"   varying vec3 vertex_normal;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       vec4 light_position = vec4(0.0,1.0,0.0,1.0);\n"
	"       vec4 specular_position = vec4(0.0,0.707107,0.707107,1.0);\n"
	"       mat4 modelview_mat = gl_ModelViewMatrix;\n"
	"       mat4 trans_modelview_mat = modelview_mat;\n"
	"\n"
	"       trans_modelview_mat[1][0] = modelview_mat[0][1];\n"
	"       trans_modelview_mat[2][0] = modelview_mat[0][2];\n"
	"       trans_modelview_mat[0][1] = modelview_mat[1][0];\n"
	"       trans_modelview_mat[0][2] = modelview_mat[2][0];\n"
	"       trans_modelview_mat[1][2] = modelview_mat[2][1];\n"
	"       trans_modelview_mat[2][1] = modelview_mat[1][2];\n"
	"\n"
	"       light_position = trans_modelview_mat * light_position;\n"
	"       specular_position = trans_modelview_mat * specular_position;\n"
	"       vertex_angle = max(dot(normal, vec3(light_position.x,light_position.y,light_position.z)),0.0);\n"
	"       vertex_specular = max(dot(normal, vec3(specular_position.x,specular_position.y,specular_position.z)),0.0) * specular;\n"
	"       vertex_normal = normal;\n"
	"\n"
	"       gl_Position = gl_ModelViewProjectionMatrix * vec4(vertex.x + offset.x,vertex.y + offset.y,vertex.z + offset.z,1.0);\n "
	"   }\n";
	
	static const char *triangle_fragment_shader =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   varying vec3 vertex_normal;\n"
	"   uniform vec4 color;\n"
	"   varying float vertex_angle;\n"
	"   varying float vertex_specular;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       vec4 fragment_color;\n"
	"\n"
	"       float diffuse_level = vertex_angle * 0.1;\n"
	"\n"
	"       fragment_color = color * vec4(0.8, 0.8, 0.8, 1.0);\n"
	"       fragment_color += color * vec4(diffuse_level,diffuse_level,diffuse_level, 1.0);\n"
	"       fragment_color += vec4(vertex_specular,vertex_specular,vertex_specular, 1.0);\n"
	"       fragment_color.w = color.w;\n"
	"       gl_FragColor = clamp(fragment_color, 0.0, 1.0);\n"
	"   }\n";
	
	static const char *triangle_vertex_shader_vertex_color =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   uniform vec3 offset;\n"
	"   uniform float specular;\n"
	"   attribute vec3 vertex;\n"
	"   attribute vec3 normal;\n"
	"   attribute vec3 color;\n"
	"   varying float vertex_angle;\n"
	"   varying float vertex_specular;\n"
	"   varying vec3 vertex_normal;\n"
	"   varying vec4 frag_color;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       vec4 light_position = vec4(0.0,1.0,0.0,1.0);\n"
	"       vec4 specular_position = vec4(0.0,0.707107,0.707107,1.0);\n"
	"       mat4 modelview_mat = gl_ModelViewMatrix;\n"
	"       mat4 trans_modelview_mat = modelview_mat;\n"
	"\n"
	"       trans_modelview_mat[1][0] = modelview_mat[0][1];\n"
	"       trans_modelview_mat[2][0] = modelview_mat[0][2];\n"
	"       trans_modelview_mat[0][1] = modelview_mat[1][0];\n"
	"       trans_modelview_mat[0][2] = modelview_mat[2][0];\n"
	"       trans_modelview_mat[1][2] = modelview_mat[2][1];\n"
	"       trans_modelview_mat[2][1] = modelview_mat[1][2];\n"
	"\n"
	"       light_position = trans_modelview_mat * light_position;\n"
	"       specular_position = trans_modelview_mat * specular_position;\n"
	"       vertex_angle = max(dot(normal, vec3(light_position.x,light_position.y,light_position.z)),0.0);\n"
	"       vertex_specular = max(dot(normal, vec3(specular_position.x,specular_position.y,specular_position.z)),0.0) * specular;\n"
	"       vertex_normal = normal;\n"
	"		frag_color = vec4(color,1.0);\n"
	"\n"
	"       gl_Position = gl_ModelViewProjectionMatrix * vec4(vertex.x + offset.x,vertex.y + offset.y,vertex.z + offset.z,1.0);\n "
	"   }\n";
	
	static const char *triangle_fragment_shader_vertex_color =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   varying vec3 vertex_normal;\n"
	"   varying vec4 frag_color;\n"
	"   varying float vertex_angle;\n"
	"   varying float vertex_specular;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       vec4 fragment_color;\n"
	"\n"
	"       float diffuse_level = vertex_angle * 0.2;\n"
	"\n"
	"       fragment_color = frag_color * vec4(0.8, 0.8, 0.8, 1.0);\n"
	"       fragment_color += frag_color * vec4(diffuse_level,diffuse_level,diffuse_level, 1.0);\n"
	"       fragment_color += vec4(vertex_specular,vertex_specular,vertex_specular, 1.0);\n"
	"       fragment_color.w = frag_color.w;\n"
	"       gl_FragColor = clamp(fragment_color, 0.0, 1.0);\n"
	"   }\n";

	
	static const char *basic_vertex_shader =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   uniform vec4 color;\n"
	"   attribute vec3 vertex;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       gl_Position = gl_ModelViewProjectionMatrix * vec4(vertex,1.0);\n "
	"   }\n";
	
	static const char *basic_fragment_shader =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   varying vec3 vertex_normal;\n"
	"   uniform vec4 color;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       gl_FragColor = clamp(color, 0.0, 1.0);\n"
	"   }\n";
	
	static const char *basic_vertex_shader_vertex_color =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   attribute vec4 color;\n"
	"   attribute vec3 vertex;\n"
	"   varying vec4 frag_color;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"		frag_color = color;\n"
	"       gl_Position = gl_ModelViewProjectionMatrix * vec4(vertex,1.0);\n "
	"   }\n";
	
	static const char *basic_fragment_shader_vertex_color =
	//" #version 100\n"  // OpenGL ES 2.0
	//"	#version 120\n"  // OpenGL 2.1
	"   varying vec3 vertex_normal;\n"
	"   varying vec4 frag_color;\n"
	"\n"
	"   void main(void)\n"
	"   {\n"
	"       gl_FragColor = clamp(frag_color, 0.0, 1.0);\n"
	"   }\n";

}

#endif
