/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <cstring>

#include "openglvertexbuffer.h"

static const int						INITIAL_BUFFER_ID(1);

TOpenGLVertexBuffer::TOpenGLVertexBuffer(void)
{
	d_next_id = INITIAL_BUFFER_ID;
}

TOpenGLVertexBuffer::~TOpenGLVertexBuffer(void)
{
	std::vector<TOpenGLVertexBuffer::TBufferItem>::iterator iter;

	for(iter = d_buffer_items.begin();iter != d_buffer_items.end();++iter)
	{
		if((*iter).buffer)
		{
			delete[] (*iter).buffer;
		}
	}
	
	d_buffer_items.clear();
}

bool TOpenGLVertexBuffer::Has_Buffer(
	const int							id) const
{
	std::vector<TOpenGLVertexBuffer::TBufferItem>::const_iterator iter;
	
	if(id < INITIAL_BUFFER_ID)
	{
		return false;
	}
	
	for(iter = d_buffer_items.begin();iter != d_buffer_items.end();++iter)
	{
		if((*iter).id == id)
		{
			return true;
		}
	}
	
	return false;
}

double* TOpenGLVertexBuffer::Buffer(
	const int							id) const
{
	std::vector<TOpenGLVertexBuffer::TBufferItem>::const_iterator iter;
	
	if(id < INITIAL_BUFFER_ID)
	{
		return 0;
	}
	
	for(iter = d_buffer_items.begin();iter != d_buffer_items.end();++iter)
	{
		if((*iter).id == id)
		{
			return (*iter).buffer;
		}
	}
	
	return 0;
}

unsigned int TOpenGLVertexBuffer::Buffer_Size(
	const int							id) const
{
	std::vector<TOpenGLVertexBuffer::TBufferItem>::const_iterator iter;
	
	if(id < INITIAL_BUFFER_ID)
	{
		return 0;
	}
	
	for(iter = d_buffer_items.begin();iter != d_buffer_items.end();++iter)
	{
		if((*iter).id == id)
		{
			return (*iter).size;
		}
	}
	
	return 0;
}

int TOpenGLVertexBuffer::Create_Buffer(
	const unsigned int					size)
{
	TOpenGLVertexBuffer::TBufferItem	buffer_item;
	
	if(size > 0 && (size % 3) == 0)		// buffer size must be multiple of 3
	{
		buffer_item.buffer = new double[size];
		
		if(buffer_item.buffer)
		{
			memset(buffer_item.buffer,0,sizeof(double) * size);
			
			buffer_item.id = d_next_id++;
			buffer_item.size = size;
			
			d_buffer_items.push_back(buffer_item);
			
			return buffer_item.id;
		}
	}
	
	return -1;
}

void TOpenGLVertexBuffer::Remove_Buffer(
	const int							id)
{
	std::vector<TOpenGLVertexBuffer::TBufferItem>::iterator iter;
	
	for(iter = d_buffer_items.begin();iter != d_buffer_items.end();++iter)
	{
		if((*iter).id == id)
		{
			if((*iter).buffer)
			{
				delete[] (*iter).buffer;
			}
			
			d_buffer_items.erase(iter);
			return;
		}
	}
}

void TOpenGLVertexBuffer::Clear(void)
{
	std::vector<TOpenGLVertexBuffer::TBufferItem>::iterator iter;
	
	for(iter = d_buffer_items.begin();iter != d_buffer_items.end();++iter)
	{
		if((*iter).buffer)
		{
			delete[] (*iter).buffer;
		}
	}
	
	d_buffer_items.clear();
}
