/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef ARTIFACTBALLBARWIDGETHEADERFILE
#define ARTIFACTBALLBARWIDGETHEADERFILE

#include <QWidget>

#include "../../core/vector3.h"

class QLineEdit;
class QListWidget;
class QListWidgetItem;

class TArtifactBallbarWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TArtifactBallbarWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TArtifactBallbarWidget(void);

// ACCESSORS
	TVector3 Attribute_Position(void) const;
	TVector3 Attribute_Axis(void) const;
	double Attribute_Length(void) const;

// MANIPULATORS
	void Set_Tool_Offset(const TVector3 &offset) {d_tool_offset = offset;}
	void Set_Head_AB(const double &head_a,const double &head_b) {d_head_a = head_a;d_head_b = head_b;}

	void Set_Attribute_Position(const TVector3 &pos);
	void Set_Attribute_Axis(const TVector3 &axis);
	void Set_Attribute_Length(const double &len);

signals:
	void Touch_Point(const double&,const double&,const double&,const double&,const double&,const double&);	// xyzijk

private slots:
	void Touch_Double_Clicked(QListWidgetItem*);

private:
	QLineEdit							*d_axis_i_edit;
	QLineEdit							*d_axis_j_edit;
	QLineEdit							*d_axis_k_edit;
	QLineEdit							*d_length_edit;
	QLineEdit							*d_pos_x_edit;
	QLineEdit							*d_pos_y_edit;
	QLineEdit							*d_pos_z_edit;
	QListWidget							*d_points_list;
	
	TVector3							d_tool_offset;
	double								d_head_a;
	double								d_head_b;

// NOT IMPLEMENTED
	TArtifactBallbarWidget(const TArtifactBallbarWidget&);
	TArtifactBallbarWidget& operator=(const TArtifactBallbarWidget&);
};

#endif
