/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef ARTIFACTCONTAINERWIDGETHEADERFILE
#define ARTIFACTCONTAINERWIDGETHEADERFILE

#include <QWidget>

#include "../../core/vector3.h"

class QComboBox;
class QStackedWidget;

class TArtifactBallbarWidget;
class TArtifactFreePointsWidget;
class TArtifactGaugeBlockWidget;
class TArtifactRingGaugeWidget;
class TArtifactSphereWidget;
class TArtifactStepgaugeWidget;

class TArtifactContainerWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TArtifactContainerWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TArtifactContainerWidget(void);

// ACCESSORS
	bool Save_FreeTouch_Points(const QString &data_path) const;
	
	TVector3 Ballbar_Attribute_Position(void) const;
	TVector3 Ballbar_Attribute_Axis(void) const;
	double Ballbar_Attribute_Length(void) const;

	TVector3 Gaugeblock_Attribute_Position(void) const;
	TVector3 Gaugeblock_Attribute_Axis(void) const;
	double Gaugeblock_Attribute_Length(void) const;

	TVector3 Ringgauge_Attribute_Position(void) const;
	TVector3 Ringgauge_Attribute_Axis(void) const;
	double Ringgauge_Attribute_Diameter(void) const;
	bool Ringgauge_Attribute_ID(void) const;
	
	TVector3 Sphere_Attribute_Position(void) const;
	double Sphere_Attribute_Diameter(void) const;

	TVector3 Stepgauge_Attribute_Position(void) const;
	TVector3 Stepgauge_Attribute_Axis(void) const;
	double Stepgauge_Attribute_Length(void) const;


// MANIPULATORS
	bool Load_FreeTouch_Points(const QString &data_path);

	void Set_Tool(const TVector3 &offset, const double &tip_diameter);
	void Set_Head_AB(const double &head_a,const double &head_b);
	void Set_Tool_Tip_Diameter(const double &tip_diameter) {d_tip_radius = tip_diameter / 2.0;}
	
	void Set_Ballbar_Attribute_Position(const TVector3 &pos);
	void Set_Ballbar_Attribute_Axis(const TVector3 &axis);
	void Set_Ballbar_Attribute_Length(const double &len);
	
	void Set_Gaugeblock_Attribute_Position(const TVector3 &pos);
	void Set_Gaugeblock_Attribute_Axis(const TVector3 &axis);
	void Set_Gaugeblock_Attribute_Length(const double &len);
	
	void Set_Ringgauge_Attribute_Position(const TVector3 &pos);
	void Set_Ringgauge_Attribute_Axis(const TVector3 &axis);
	void Set_Ringgauge_Attribute_Diameter(const double &diam);
	void Set_Ringgauge_Attribute_ID(const bool state);
	
	void Set_Sphere_Attribute_Position(const TVector3 &pos);
	void Set_Sphere_Attribute_Diameter(const double &diam);
	
	void Set_Stepgauge_Attribute_Position(const TVector3 &pos);
	void Set_Stepgauge_Attribute_Axis(const TVector3 &axis);
	void Set_Stepgauge_Attribute_Length(const double &len);


signals:
	void Touch(const double&,const double&,const double&,const double&,const double&,const double&,const bool);	// xyzijk, bool for ballbar pre-compensation

private slots:
	void Add_Manual_Touch(const double &x,const double &y,const double &z,const double &i,const double &j,const double &k);

private:
	QComboBox							*d_artifact_type_combo;
	QStackedWidget						*d_widget_stack;
	
	TArtifactBallbarWidget				*d_artifact_ballbar_widget;
	TArtifactFreePointsWidget			*d_artifact_freepoints_widget;
	TArtifactGaugeBlockWidget			*d_artifact_gaugeblock_widget;
	TArtifactRingGaugeWidget			*d_artifact_ringgauge_widget;
	TArtifactSphereWidget				*d_artifact_sphere_widget;
	TArtifactStepgaugeWidget			*d_artifact_stepgauge_widget;
	
	TVector3							d_tool_offset;
	double								d_tip_radius;


// NOT IMPLEMENTED
	TArtifactContainerWidget(const TArtifactContainerWidget&);
	TArtifactContainerWidget& operator=(const TArtifactContainerWidget&);
};

#endif
